/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import io.atomix.resource.ResourceType;
import java.util.concurrent.CompletableFuture;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onosproject.store.primitives.resources.impl.AtomixAtomicCounterMap;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;

public class AtomixAtomicCounterMapTest
extends AtomixTestBase {
    @BeforeClass
    public static void preTestSetup() throws Throwable {
        AtomixAtomicCounterMapTest.createCopycatServers(3);
    }

    @AfterClass
    public static void postTestCleanup() throws Exception {
        AtomixAtomicCounterMapTest.clearTests();
    }

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(AtomixAtomicCounterMap.class);
    }

    @Test
    public void testBasicCounterMapOperations() throws Throwable {
        AtomixAtomicCounterMap map = (AtomixAtomicCounterMap)this.createAtomixClient().getResource("testBasicCounterMapOperationMap", AtomixAtomicCounterMap.class).join();
        ((CompletableFuture)map.isEmpty().thenAccept(isEmpty -> Assert.assertTrue((boolean)isEmpty))).join();
        ((CompletableFuture)map.size().thenAccept(size -> Assert.assertTrue((size == 0 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.put("foo", 2L).thenAccept(value -> Assert.assertTrue((value == 0L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.incrementAndGet("foo").thenAccept(value -> Assert.assertTrue((value == 3L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.getAndIncrement("foo").thenAccept(value -> Assert.assertTrue((value == 3L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.get("foo").thenAccept(value -> Assert.assertTrue((value == 4L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.getAndDecrement("foo").thenAccept(value -> Assert.assertTrue((value == 4L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.decrementAndGet("foo").thenAccept(value -> Assert.assertTrue((value == 2L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.size().thenAccept(size -> Assert.assertTrue((size == 1 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(isEmpty -> Assert.assertFalse((boolean)isEmpty))).join();
        map.clear().join();
        ((CompletableFuture)map.isEmpty().thenAccept(isEmpty -> Assert.assertTrue((boolean)isEmpty))).join();
        ((CompletableFuture)map.size().thenAccept(size -> Assert.assertTrue((size == 0 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.get("foo").thenAccept(value -> Assert.assertTrue((value == 0L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.incrementAndGet("bar").thenAccept(value -> Assert.assertTrue((value == 1L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.addAndGet("bar", 2L).thenAccept(value -> Assert.assertTrue((value == 3L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.getAndAdd("bar", 3L).thenAccept(value -> Assert.assertTrue((value == 3L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.get("bar").thenAccept(value -> Assert.assertTrue((value == 6L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.putIfAbsent("bar", 1L).thenAccept(value -> Assert.assertTrue((value == 6L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.replace("bar", 6L, 1L).thenAccept(succeeded -> Assert.assertTrue((boolean)succeeded))).join();
        ((CompletableFuture)map.replace("bar", 6L, 1L).thenAccept(succeeded -> Assert.assertFalse((boolean)succeeded))).join();
        ((CompletableFuture)map.size().thenAccept(size -> Assert.assertTrue((size == 1 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.remove("bar").thenAccept(value -> Assert.assertTrue((value == 1L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.size().thenAccept(size -> Assert.assertTrue((size == 0 ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.put("baz", 3L).thenAccept(value -> Assert.assertTrue((value == 0L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.remove("baz", 2L).thenAccept(removed -> Assert.assertFalse((boolean)removed))).join();
        ((CompletableFuture)map.put("baz", 2L).thenAccept(value -> Assert.assertTrue((value == 3L ? 1 : 0) != 0))).join();
        ((CompletableFuture)map.remove("baz", 2L).thenAccept(removed -> Assert.assertTrue((boolean)removed))).join();
        ((CompletableFuture)map.isEmpty().thenAccept(isEmpty -> Assert.assertTrue((boolean)isEmpty))).join();
        ((CompletableFuture)map.replace("baz", 0L, 5L).thenAccept(replaced -> Assert.assertTrue((boolean)replaced))).join();
        ((CompletableFuture)map.get("baz").thenAccept(value -> Assert.assertTrue((value == 5L ? 1 : 0) != 0))).join();
    }
}

