/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import io.atomix.AtomixClient;
import io.atomix.resource.ResourceType;
import io.atomix.variables.DistributedLong;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onosproject.store.primitives.resources.impl.AtomixCounter;
import org.onosproject.store.primitives.resources.impl.AtomixTestBase;

public class AtomixLongTest
extends AtomixTestBase {
    @BeforeClass
    public static void preTestSetup() throws Throwable {
        AtomixLongTest.createCopycatServers(3);
    }

    @AfterClass
    public static void postTestCleanup() throws Exception {
        AtomixLongTest.clearTests();
    }

    @Override
    protected ResourceType resourceType() {
        return new ResourceType(DistributedLong.class);
    }

    @Test
    public void testBasicOperations() throws Throwable {
        this.basicOperationsTest();
    }

    protected void basicOperationsTest() throws Throwable {
        AtomixClient atomix = this.createAtomixClient();
        AtomixCounter along = new AtomixCounter("test-long-basic-operations", (DistributedLong)atomix.getLong("test-long").join());
        Assert.assertEquals((long)0L, (long)((Long)along.get().join()));
        Assert.assertEquals((long)1L, (long)((Long)along.incrementAndGet().join()));
        along.set(100L).join();
        Assert.assertEquals((long)100L, (long)((Long)along.get().join()));
        Assert.assertEquals((long)100L, (long)((Long)along.getAndAdd(10L).join()));
        Assert.assertEquals((long)110L, (long)((Long)along.get().join()));
        Assert.assertFalse((boolean)((Boolean)along.compareAndSet(109L, 111L).join()));
        Assert.assertTrue((boolean)((Boolean)along.compareAndSet(110L, 111L).join()));
        Assert.assertEquals((long)100L, (long)((Long)along.addAndGet(-11L).join()));
        Assert.assertEquals((long)100L, (long)((Long)along.getAndIncrement().join()));
        Assert.assertEquals((long)101L, (long)((Long)along.get().join()));
    }
}

