/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.utils.MeteringAgent;

public class DefaultTransactionContext
implements TransactionContext {
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private final TransactionId transactionId;
    private final TransactionCoordinator transactionCoordinator;
    private final MeteringAgent monitor;

    public DefaultTransactionContext(TransactionId transactionId, TransactionCoordinator transactionCoordinator) {
        this.transactionId = transactionId;
        this.transactionCoordinator = transactionCoordinator;
        this.monitor = new MeteringAgent("transactionContext", "*", true);
    }

    public String name() {
        return this.transactionId.toString();
    }

    public TransactionId transactionId() {
        return this.transactionId;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public void begin() {
        if (!this.isOpen.compareAndSet(false, true)) {
            throw new IllegalStateException("TransactionContext is already open");
        }
    }

    public CompletableFuture<CommitStatus> commit() {
        MeteringAgent.Context timer = this.monitor.startTimer("commit");
        return this.transactionCoordinator.commit().whenComplete((r, e) -> timer.stop(e));
    }

    public void abort() {
        this.isOpen.set(false);
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        return this.transactionCoordinator.getTransactionalMap(mapName, serializer);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionId", (Object)this.transactionId).toString();
    }
}

