/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionalMapParticipant;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class DefaultTransactionalMapParticipant<K, V>
extends TransactionalMapParticipant<K, V> {
    private final Map<K, Versioned<V>> readCache = Maps.newConcurrentMap();

    public DefaultTransactionalMapParticipant(ConsistentMap<K, V> backingMap, Transaction<MapUpdate<K, V>> transaction) {
        super(backingMap, transaction);
    }

    @Override
    protected V read(K key) {
        Versioned value = this.backingMap.getOrDefault(key, null);
        this.readCache.put(key, value);
        return (V)value.value();
    }

    @Override
    public boolean hasPendingUpdates() {
        return !this.writeCache.isEmpty() || !this.deleteSet.isEmpty();
    }

    @Override
    protected Stream<MapUpdate<K, V>> records(Version lockVersion) {
        return Stream.concat(this.deleteStream(), this.writeStream(lockVersion));
    }

    private Stream<MapUpdate<K, V>> deleteStream() {
        return this.deleteSet.stream().map(key -> Pair.of((Object)key, this.readCache.get(key))).map(e -> MapUpdate.newBuilder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(e.getKey()).withVersion(((Versioned)e.getValue()).version()).build());
    }

    private Stream<MapUpdate<K, V>> writeStream(Version lockVersion) {
        return this.writeCache.entrySet().stream().map(entry -> {
            Versioned<V> original = this.readCache.get(entry.getKey());
            return MapUpdate.newBuilder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(entry.getKey()).withValue(entry.getValue()).withVersion(Math.max(original.version(), lockVersion.value())).build();
        });
    }
}

