/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.TransactionException;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Version;

public abstract class TransactionalMapParticipant<K, V>
implements TransactionalMap<K, V>,
TransactionParticipant {
    private static final String TX_CLOSED_ERROR = "Transaction is closed";
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private static final String ERROR_NULL_KEY = "Null key is not allowed";
    protected final ConsistentMap<K, V> backingMap;
    protected final Transaction<MapUpdate<K, V>> transaction;
    protected final Map<K, V> writeCache = Maps.newConcurrentMap();
    protected final Set<K> deleteSet = Sets.newConcurrentHashSet();
    protected volatile Version lock;

    protected TransactionalMapParticipant(ConsistentMap<K, V> backingMap, Transaction<MapUpdate<K, V>> transaction) {
        this.backingMap = backingMap;
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginTransaction() {
        if (this.lock == null) {
            TransactionalMapParticipant transactionalMapParticipant = this;
            synchronized (transactionalMapParticipant) {
                if (this.lock == null) {
                    try {
                        this.lock = this.transaction.begin().get(5000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new TransactionException.Interrupted();
                    }
                    catch (TimeoutException e) {
                        throw new TransactionException.Timeout();
                    }
                    catch (ExecutionException e) {
                        Throwables.propagateIfPossible((Throwable)e.getCause());
                        throw new TransactionException(e.getCause());
                    }
                }
            }
        }
    }

    public V get(K key) {
        this.beginTransaction();
        Preconditions.checkState((boolean)this.transaction.isOpen(), (Object)TX_CLOSED_ERROR);
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        if (this.deleteSet.contains(key)) {
            return null;
        }
        V latest = this.writeCache.get(key);
        if (latest != null) {
            return latest;
        }
        return this.read(key);
    }

    protected abstract V read(K var1);

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V put(K key, V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        this.writeCache.put(key, value);
        this.deleteSet.remove(key);
        return latest;
    }

    public V remove(K key) {
        V latest = this.get(key);
        if (latest != null) {
            this.writeCache.remove(key);
            this.deleteSet.add(key);
        }
        return latest;
    }

    public boolean remove(K key, V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(value, latest)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(oldValue, (Object)ERROR_NULL_VALUE);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (Objects.equal(oldValue, latest)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    public V putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        V latest = this.get(key);
        if (latest == null) {
            this.put(key, value);
        }
        return latest;
    }

    @Override
    public CompletableFuture<Boolean> prepare() {
        return this.transaction.prepare(this.log(this.lock));
    }

    @Override
    public CompletableFuture<Void> commit() {
        return this.transaction.commit();
    }

    @Override
    public CompletableFuture<Boolean> prepareAndCommit() {
        return this.transaction.prepareAndCommit(this.log(this.lock));
    }

    @Override
    public CompletableFuture<Void> rollback() {
        return this.transaction.rollback();
    }

    protected List<MapUpdate<K, V>> log(Version lockVersion) {
        return this.records(lockVersion).collect(Collectors.toList());
    }

    protected abstract Stream<MapUpdate<K, V>> records(Version var1);

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backingMap", this.backingMap).toString();
    }
}

