/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.primitives.resources.impl.AtomixLeaderElectorCommands;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixLeaderElectorState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, AtomicLong> termCounters = new HashMap<String, AtomicLong>();
    private Map<String, ElectionState> elections = new HashMap<String, ElectionState>();
    private final Map<Long, Commit<? extends AtomixLeaderElectorCommands.Listen>> listeners = new LinkedHashMap<Long, Commit<? extends AtomixLeaderElectorCommands.Listen>>();
    private final Serializer serializer = Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{ElectionState.class, Registration.class});

    public AtomixLeaderElectorState(Properties properties) {
        super(properties);
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixLeaderElectorCommands.Listen.class, this::listen);
        executor.register(AtomixLeaderElectorCommands.Unlisten.class, this::unlisten);
        executor.register(AtomixLeaderElectorCommands.Run.class, this::run);
        executor.register(AtomixLeaderElectorCommands.Withdraw.class, this::withdraw);
        executor.register(AtomixLeaderElectorCommands.Anoint.class, this::anoint);
        executor.register(AtomixLeaderElectorCommands.Promote.class, this::promote);
        executor.register(AtomixLeaderElectorCommands.Evict.class, this::evict);
        executor.register(AtomixLeaderElectorCommands.GetLeadership.class, this::leadership);
        executor.register(AtomixLeaderElectorCommands.GetAllLeaderships.class, this::allLeaderships);
        executor.register(AtomixLeaderElectorCommands.GetElectedTopics.class, this::electedTopics);
    }

    private void notifyLeadershipChange(Leadership previousLeadership, Leadership newLeadership) {
        this.notifyLeadershipChanges(Lists.newArrayList((Object[])new Change[]{new Change((Object)previousLeadership, (Object)newLeadership)}));
    }

    private void notifyLeadershipChanges(List<Change<Leadership>> changes) {
        if (changes.isEmpty()) {
            return;
        }
        this.listeners.values().forEach(listener -> listener.session().publish("leadershipChangeEvents", (Object)changes));
    }

    public void delete() {
        this.listeners.values().forEach(Commit::close);
        this.listeners.clear();
    }

    public void listen(Commit<? extends AtomixLeaderElectorCommands.Listen> commit) {
        Long sessionId = commit.session().id();
        if (this.listeners.putIfAbsent(commit.session().id(), commit) != null) {
            commit.close();
        }
        commit.session().onStateChange(state -> {
            Commit<? extends AtomixLeaderElectorCommands.Listen> listener;
            if ((state == Session.State.CLOSED || state == Session.State.EXPIRED) && (listener = this.listeners.remove(sessionId)) != null) {
                listener.close();
            }
        });
    }

    public void unlisten(Commit<? extends AtomixLeaderElectorCommands.Unlisten> commit) {
        try {
            Commit<? extends AtomixLeaderElectorCommands.Listen> listener = this.listeners.remove(commit.session().id());
            if (listener != null) {
                listener.close();
            }
        }
        finally {
            commit.close();
        }
    }

    public Leadership run(Commit<? extends AtomixLeaderElectorCommands.Run> commit) {
        try {
            String topic = ((AtomixLeaderElectorCommands.Run)commit.operation()).topic();
            Leadership oldLeadership = this.leadership(topic);
            Registration registration = new Registration(((AtomixLeaderElectorCommands.Run)commit.operation()).nodeId(), commit.session().id());
            this.elections.compute(topic, (k, v) -> {
                if (v == null) {
                    return new ElectionState(registration, this.termCounter(topic)::incrementAndGet);
                }
                if (!v.isDuplicate(registration)) {
                    return new ElectionState((ElectionState)v).addRegistration(registration, this.termCounter(topic)::incrementAndGet);
                }
                return v;
            });
            Leadership newLeadership = this.leadership(topic);
            if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            Leadership leadership = newLeadership;
            return leadership;
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    public void withdraw(Commit<? extends AtomixLeaderElectorCommands.Withdraw> commit) {
        try {
            String topic = ((AtomixLeaderElectorCommands.Withdraw)commit.operation()).topic();
            Leadership oldLeadership = this.leadership(topic);
            this.elections.computeIfPresent(topic, (k, v) -> v.cleanup(commit.session(), this.termCounter(topic)::incrementAndGet));
            Leadership newLeadership = this.leadership(topic);
            if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    public boolean anoint(Commit<? extends AtomixLeaderElectorCommands.Anoint> commit) {
        try {
            String topic = ((AtomixLeaderElectorCommands.Anoint)commit.operation()).topic();
            NodeId nodeId = ((AtomixLeaderElectorCommands.Anoint)commit.operation()).nodeId();
            Leadership oldLeadership = this.leadership(topic);
            ElectionState electionState = this.elections.computeIfPresent(topic, (k, v) -> v.transferLeadership(nodeId, this.termCounter(topic)));
            Leadership newLeadership = this.leadership(topic);
            if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            boolean bl = electionState != null && electionState.leader() != null && ((AtomixLeaderElectorCommands.Anoint)commit.operation()).nodeId().equals((Object)electionState.leader().nodeId());
            return bl;
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    public boolean promote(Commit<? extends AtomixLeaderElectorCommands.Promote> commit) {
        try {
            String topic = ((AtomixLeaderElectorCommands.Promote)commit.operation()).topic();
            NodeId nodeId = ((AtomixLeaderElectorCommands.Promote)commit.operation()).nodeId();
            Leadership oldLeadership = this.leadership(topic);
            if (oldLeadership == null || !oldLeadership.candidates().contains(nodeId)) {
                boolean bl = false;
                return bl;
            }
            this.elections.computeIfPresent(topic, (k, v) -> v.promote(nodeId));
            Leadership newLeadership = this.leadership(topic);
            if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                this.notifyLeadershipChange(oldLeadership, newLeadership);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    public void evict(Commit<? extends AtomixLeaderElectorCommands.Evict> commit) {
        try {
            ArrayList changes = Lists.newArrayList();
            NodeId nodeId = ((AtomixLeaderElectorCommands.Evict)commit.operation()).nodeId();
            Set topics = Maps.filterValues(this.elections, e -> e.candidates().contains(nodeId)).keySet();
            topics.forEach(topic -> {
                Leadership oldLeadership = this.leadership((String)topic);
                this.elections.compute((String)topic, (k, v) -> v.evict(nodeId, this.termCounter((String)topic)::incrementAndGet));
                Leadership newLeadership = this.leadership((String)topic);
                if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                    changes.add(new Change((Object)oldLeadership, (Object)newLeadership));
                }
            });
            this.notifyLeadershipChanges(changes);
        }
        catch (Exception e2) {
            this.log.error("State machine operation failed", (Throwable)e2);
            throw Throwables.propagate((Throwable)e2);
        }
        finally {
            commit.close();
        }
    }

    public Leadership leadership(Commit<? extends AtomixLeaderElectorCommands.GetLeadership> commit) {
        String topic = ((AtomixLeaderElectorCommands.GetLeadership)commit.operation()).topic();
        try {
            Leadership leadership = this.leadership(topic);
            return leadership;
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    public Set<String> electedTopics(Commit<? extends AtomixLeaderElectorCommands.GetElectedTopics> commit) {
        try {
            NodeId nodeId = ((AtomixLeaderElectorCommands.GetElectedTopics)commit.operation()).nodeId();
            ImmutableSet immutableSet = ImmutableSet.copyOf(Maps.filterEntries(this.elections, e -> {
                Leader leader = this.leadership((String)e.getKey()).leader();
                return leader != null && leader.nodeId().equals((Object)nodeId);
            }).keySet());
            return immutableSet;
        }
        catch (Exception e2) {
            this.log.error("State machine operation failed", (Throwable)e2);
            throw Throwables.propagate((Throwable)e2);
        }
        finally {
            commit.close();
        }
    }

    public Map<String, Leadership> allLeaderships(Commit<? extends AtomixLeaderElectorCommands.GetAllLeaderships> commit) {
        HashMap<String, Leadership> result = new HashMap<String, Leadership>();
        try {
            result.putAll(Maps.transformEntries(this.elections, (k, v) -> this.leadership((String)k)));
            HashMap<String, Leadership> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            this.log.error("State machine operation failed", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            commit.close();
        }
    }

    private Leadership leadership(String topic) {
        return new Leadership(topic, this.leader(topic), this.candidates(topic));
    }

    private Leader leader(String topic) {
        ElectionState electionState = this.elections.get(topic);
        return electionState == null ? null : electionState.leader();
    }

    private List<NodeId> candidates(String topic) {
        ElectionState electionState = this.elections.get(topic);
        return electionState == null ? new LinkedList() : electionState.candidates();
    }

    private void onSessionEnd(ServerSession session) {
        Commit<? extends AtomixLeaderElectorCommands.Listen> listener = this.listeners.remove(session.id());
        if (listener != null) {
            listener.close();
        }
        Set<String> topics = this.elections.keySet();
        ArrayList changes = Lists.newArrayList();
        topics.forEach(topic -> {
            Leadership oldLeadership = this.leadership((String)topic);
            this.elections.compute((String)topic, (k, v) -> v.cleanup(session, this.termCounter((String)topic)::incrementAndGet));
            Leadership newLeadership = this.leadership((String)topic);
            if (!Objects.equal((Object)oldLeadership, (Object)newLeadership)) {
                changes.add(new Change((Object)oldLeadership, (Object)newLeadership));
            }
        });
        this.notifyLeadershipChanges(changes);
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
        this.onSessionEnd(session);
    }

    public void expire(ServerSession session) {
        this.onSessionEnd(session);
    }

    public void close(ServerSession session) {
        this.onSessionEnd(session);
    }

    public void snapshot(SnapshotWriter writer) {
        byte[] encodedTermCounters = this.serializer.encode(this.termCounters);
        writer.writeInt(encodedTermCounters.length);
        writer.write(encodedTermCounters);
        byte[] encodedElections = this.serializer.encode(this.elections);
        writer.writeInt(encodedElections.length);
        writer.write(encodedElections);
        this.log.debug("Took state machine snapshot");
    }

    public void install(SnapshotReader reader) {
        int encodedTermCountersSize = reader.readInt();
        byte[] encodedTermCounters = new byte[encodedTermCountersSize];
        reader.read(encodedTermCounters);
        this.termCounters = (Map)this.serializer.decode(encodedTermCounters);
        int encodedElectionsSize = reader.readInt();
        byte[] encodedElections = new byte[encodedElectionsSize];
        reader.read(encodedElections);
        this.elections = (Map)this.serializer.decode(encodedElections);
        this.log.debug("Reinstated state machine from snapshot");
    }

    private AtomicLong termCounter(String topic) {
        return this.termCounters.computeIfAbsent(topic, k -> new AtomicLong(0L));
    }

    private static class ElectionState {
        final Registration leader;
        final long term;
        final long termStartTime;
        final List<Registration> registrations;

        public ElectionState(Registration registration, Supplier<Long> termCounter) {
            this.registrations = Arrays.asList(registration);
            this.term = termCounter.get();
            this.termStartTime = System.currentTimeMillis();
            this.leader = registration;
        }

        public ElectionState(ElectionState other) {
            this.registrations = Lists.newArrayList(other.registrations);
            this.leader = other.leader;
            this.term = other.term;
            this.termStartTime = other.termStartTime;
        }

        public ElectionState(List<Registration> registrations, Registration leader, long term, long termStartTime) {
            this.registrations = Lists.newArrayList(registrations);
            this.leader = leader;
            this.term = term;
            this.termStartTime = termStartTime;
        }

        public ElectionState cleanup(ServerSession session, Supplier<Long> termCounter) {
            Optional<Registration> registration = this.registrations.stream().filter(r -> r.sessionId() == session.id()).findFirst();
            if (registration.isPresent()) {
                List<Registration> updatedRegistrations = this.registrations.stream().filter(r -> r.sessionId() != session.id()).collect(Collectors.toList());
                if (this.leader.sessionId() == session.id()) {
                    if (updatedRegistrations.size() > 0) {
                        return new ElectionState(updatedRegistrations, (Registration)updatedRegistrations.get(0), termCounter.get(), System.currentTimeMillis());
                    }
                    return new ElectionState(updatedRegistrations, null, this.term, this.termStartTime);
                }
                return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime);
            }
            return this;
        }

        public ElectionState evict(NodeId nodeId, Supplier<Long> termCounter) {
            Optional<Registration> registration = this.registrations.stream().filter(r -> ((Registration)r).nodeId.equals((Object)nodeId)).findFirst();
            if (registration.isPresent()) {
                List<Registration> updatedRegistrations = this.registrations.stream().filter(r -> !r.nodeId().equals((Object)nodeId)).collect(Collectors.toList());
                if (this.leader.nodeId().equals((Object)nodeId)) {
                    if (updatedRegistrations.size() > 0) {
                        return new ElectionState(updatedRegistrations, (Registration)updatedRegistrations.get(0), termCounter.get(), System.currentTimeMillis());
                    }
                    return new ElectionState(updatedRegistrations, null, this.term, this.termStartTime);
                }
                return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime);
            }
            return this;
        }

        public boolean isDuplicate(Registration registration) {
            return this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId());
        }

        public Leader leader() {
            if (this.leader == null) {
                return null;
            }
            NodeId leaderNodeId = this.leader.nodeId();
            return new Leader(leaderNodeId, this.term, this.termStartTime);
        }

        public List<NodeId> candidates() {
            return this.registrations.stream().map(registration -> registration.nodeId()).collect(Collectors.toList());
        }

        public ElectionState addRegistration(Registration registration, Supplier<Long> termCounter) {
            if (!this.registrations.stream().anyMatch(r -> r.sessionId() == registration.sessionId())) {
                LinkedList<Registration> updatedRegistrations = new LinkedList<Registration>(this.registrations);
                updatedRegistrations.add(registration);
                boolean newLeader = this.leader == null;
                return new ElectionState(updatedRegistrations, newLeader ? registration : this.leader, newLeader ? termCounter.get() : this.term, newLeader ? System.currentTimeMillis() : this.termStartTime);
            }
            return this;
        }

        public ElectionState transferLeadership(NodeId nodeId, AtomicLong termCounter) {
            Registration newLeader = this.registrations.stream().filter(r -> r.nodeId().equals((Object)nodeId)).findFirst().orElse(null);
            if (newLeader != null) {
                return new ElectionState(this.registrations, newLeader, termCounter.incrementAndGet(), System.currentTimeMillis());
            }
            return this;
        }

        public ElectionState promote(NodeId nodeId) {
            Registration registration = this.registrations.stream().filter(r -> r.nodeId().equals((Object)nodeId)).findFirst().orElse(null);
            ArrayList updatedRegistrations = Lists.newArrayList();
            updatedRegistrations.add(registration);
            this.registrations.stream().filter(r -> !r.nodeId().equals((Object)nodeId)).forEach(updatedRegistrations::add);
            return new ElectionState(updatedRegistrations, this.leader, this.term, this.termStartTime);
        }
    }

    private static class Registration {
        private final NodeId nodeId;
        private final long sessionId;

        public Registration(NodeId nodeId, long sessionId) {
            this.nodeId = nodeId;
            this.sessionId = sessionId;
        }

        public NodeId nodeId() {
            return this.nodeId;
        }

        public long sessionId() {
            return this.sessionId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("nodeId", (Object)this.nodeId).add("sessionId", this.sessionId).toString();
        }
    }
}

