/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMap;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValueEvent;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Versioned;

public class AtomixValue
implements AsyncAtomicValue<String> {
    private final String name;
    private final AtomixConsistentMap atomixMap;
    private MapEventListener<String, byte[]> mapEventListener;
    private final Set<AtomicValueEventListener<String>> listeners = Sets.newIdentityHashSet();

    AtomixValue(String name, AtomixConsistentMap atomixMap) {
        this.name = name;
        this.atomixMap = atomixMap;
    }

    public CompletableFuture<Boolean> compareAndSet(String expect, String update) {
        return this.atomixMap.replace(this.name, Tools.getBytesUtf8((String)expect), Tools.getBytesUtf8((String)update));
    }

    public CompletableFuture<String> get() {
        return this.atomixMap.get(this.name).thenApply(v -> v != null ? Tools.toStringUtf8((byte[])((byte[])v.value())) : null);
    }

    public CompletableFuture<String> getAndSet(String value) {
        return this.atomixMap.put(this.name, Tools.getBytesUtf8((String)value)).thenApply(v -> v != null ? Tools.toStringUtf8((byte[])((byte[])v.value())) : null);
    }

    public CompletableFuture<Void> set(String value) {
        return this.getAndSet(value).thenApply(v -> null);
    }

    public CompletableFuture<Void> addListener(AtomicValueEventListener<String> listener) {
        if (this.mapEventListener == null) {
            this.mapEventListener = event -> {
                Versioned newValue = event.newValue();
                Versioned oldValue = event.oldValue();
                if (Objects.equals(event.key(), this.name)) {
                    listener.event(new AtomicValueEvent(this.name, (Object)(newValue == null ? null : Tools.toStringUtf8((byte[])((byte[])newValue.value()))), oldValue == null ? null : Tools.toStringUtf8((byte[])((byte[])oldValue.value()))));
                }
            };
            return this.atomixMap.addListener(this.mapEventListener).whenComplete((r, e) -> {
                if (e == null) {
                    this.listeners.add(listener);
                } else {
                    this.mapEventListener = null;
                }
            });
        }
        this.listeners.add(listener);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> removeListener(AtomicValueEventListener<String> listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            return this.atomixMap.removeListener(this.mapEventListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public String name() {
        return null;
    }
}

