/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.DistributedPrimitiveCreator;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.PartitionedTransactionalMap;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.primitives.impl.TransactionManager;
import org.onosproject.store.primitives.impl.TransactionalMapParticipant;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;

public class TransactionManagerTest {
    @Test
    public void testTransactionMapCaching() throws Exception {
        AsyncConsistentMap asyncMap = (AsyncConsistentMap)EasyMock.mock(AsyncConsistentMap.class);
        EasyMock.expect((Object)asyncMap.name()).andReturn((Object)"foo");
        EasyMock.expect((Object)asyncMap.addListener((MapEventListener)EasyMock.anyObject(MapEventListener.class), (Executor)EasyMock.anyObject(Executor.class))).andReturn(CompletableFuture.completedFuture(null)).anyTimes();
        asyncMap.addStatusChangeListener((Consumer)EasyMock.anyObject(Consumer.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)asyncMap.entrySet()).andReturn(CompletableFuture.completedFuture(new HashMap().entrySet())).anyTimes();
        ConsistentMapBuilder mapBuilder = (ConsistentMapBuilder)EasyMock.mock(ConsistentMapBuilder.class);
        EasyMock.expect((Object)mapBuilder.withName(EasyMock.anyString())).andReturn((Object)mapBuilder).anyTimes();
        EasyMock.expect((Object)mapBuilder.withSerializer((Serializer)EasyMock.anyObject(Serializer.class))).andReturn((Object)mapBuilder).anyTimes();
        EasyMock.expect((Object)mapBuilder.buildAsyncMap()).andReturn((Object)asyncMap).anyTimes();
        DistributedPrimitiveCreator primitiveCreator = (DistributedPrimitiveCreator)EasyMock.mock(DistributedPrimitiveCreator.class);
        EasyMock.expect((Object)primitiveCreator.newAsyncConsistentMap(EasyMock.anyString(), (Serializer)EasyMock.anyObject(Serializer.class))).andReturn((Object)asyncMap).anyTimes();
        StorageService storageService = (StorageService)EasyMock.mock(StorageService.class);
        EasyMock.expect((Object)storageService.consistentMapBuilder()).andReturn((Object)mapBuilder);
        PartitionService partitionService = (PartitionService)EasyMock.mock(PartitionService.class);
        HashSet partitionIds = Sets.newHashSet((Object[])new PartitionId[]{PartitionId.from((int)1), PartitionId.from((int)2), PartitionId.from((int)3)});
        EasyMock.expect((Object)partitionService.getAllPartitionIds()).andReturn((Object)partitionIds).anyTimes();
        EasyMock.expect((Object)partitionService.getNumberOfPartitions()).andReturn((Object)partitionIds.size()).anyTimes();
        EasyMock.expect((Object)partitionService.getDistributedPrimitiveCreator((PartitionId)EasyMock.anyObject(PartitionId.class))).andReturn((Object)primitiveCreator).anyTimes();
        EasyMock.replay((Object[])new Object[]{storageService, partitionService, asyncMap, primitiveCreator, mapBuilder});
        TransactionManager transactionManager = new TransactionManager(storageService, partitionService);
        TransactionId transactionId = TransactionId.from((String)UUID.randomUUID().toString());
        TransactionCoordinator transactionCoordinator = new TransactionCoordinator(transactionId, transactionManager);
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.API);
        PartitionedTransactionalMap transactionalMap1 = transactionManager.getTransactionalMap("foo", serializer, transactionCoordinator);
        PartitionedTransactionalMap transactionalMap2 = transactionManager.getTransactionalMap("foo", serializer, transactionCoordinator);
        Assert.assertSame((Object)((TransactionalMapParticipant)transactionalMap1.partitions.get((Object)PartitionId.from((int)1))).transaction.transactionalObject, (Object)((TransactionalMapParticipant)transactionalMap2.partitions.get((Object)PartitionId.from((int)1))).transaction.transactionalObject);
        Assert.assertSame((Object)((TransactionalMapParticipant)transactionalMap1.partitions.get((Object)PartitionId.from((int)2))).transaction.transactionalObject, (Object)((TransactionalMapParticipant)transactionalMap2.partitions.get((Object)PartitionId.from((int)2))).transaction.transactionalObject);
        Assert.assertSame((Object)((TransactionalMapParticipant)transactionalMap1.partitions.get((Object)PartitionId.from((int)3))).transaction.transactionalObject, (Object)((TransactionalMapParticipant)transactionalMap2.partitions.get((Object)PartitionId.from((int)3))).transaction.transactionalObject);
    }
}

