/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.DefaultTransactionalMapParticipant;
import org.onosproject.store.primitives.impl.Hasher;
import org.onosproject.store.primitives.impl.PartitionedTransactionalMap;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionCoordinator;
import org.onosproject.store.primitives.impl.TransactionManager;
import org.onosproject.store.primitives.impl.TransactionalMapParticipant;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Transactional;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class TransactionTest {
    @Test
    public void testTransaction() throws Exception {
        AsyncConsistentMap asyncMap = (AsyncConsistentMap)EasyMock.strictMock(AsyncConsistentMap.class);
        TransactionId transactionId = TransactionId.from((String)"foo");
        List<MapUpdate> updates = Collections.singletonList(new MapUpdate());
        Transaction transaction = new Transaction(transactionId, (Transactional)asyncMap);
        Assert.assertEquals((Object)transactionId, (Object)transaction.transactionId());
        EasyMock.expect((Object)asyncMap.begin(transactionId)).andReturn(CompletableFuture.completedFuture(new Version(1L)));
        EasyMock.expect((Object)asyncMap.prepare(new TransactionLog(transactionId, 1L, updates))).andReturn(CompletableFuture.completedFuture(true));
        EasyMock.expect((Object)asyncMap.commit(transactionId)).andReturn(CompletableFuture.completedFuture(null));
        EasyMock.replay((Object[])new Object[]{asyncMap});
        Assert.assertEquals((Object)Transaction.State.ACTIVE, (Object)transaction.state());
        Assert.assertEquals((long)1L, (long)((Version)transaction.begin().join()).value());
        Assert.assertEquals((Object)Transaction.State.ACTIVE, (Object)transaction.state());
        Assert.assertTrue((boolean)((Boolean)transaction.prepare(updates).join()));
        Assert.assertEquals((Object)Transaction.State.PREPARED, (Object)transaction.state());
        transaction.commit();
        Assert.assertEquals((Object)Transaction.State.COMMITTED, (Object)transaction.state());
        EasyMock.verify((Object[])new Object[]{asyncMap});
    }

    @Test
    public void testTransactionFailOnOutOfOrderCalls() throws Exception {
        AsyncConsistentMap asyncMap = (AsyncConsistentMap)EasyMock.strictMock(AsyncConsistentMap.class);
        TransactionId transactionId = TransactionId.from((String)"foo");
        List<MapUpdate> updates = Collections.singletonList(new MapUpdate());
        Transaction transaction = new Transaction(transactionId, (Transactional)asyncMap);
        try {
            transaction.prepare(updates);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            transaction.commit();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            transaction.rollback();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EasyMock.expect((Object)asyncMap.begin(transactionId)).andReturn(CompletableFuture.completedFuture(new Version(1L)));
        EasyMock.expect((Object)asyncMap.prepare(new TransactionLog(transactionId, 1L, updates))).andReturn(CompletableFuture.completedFuture(true));
        EasyMock.replay((Object[])new Object[]{asyncMap});
        Assert.assertFalse((boolean)transaction.isOpen());
        Assert.assertEquals((Object)Transaction.State.ACTIVE, (Object)transaction.state());
        Assert.assertEquals((long)1L, (long)((Version)transaction.begin().join()).value());
        Assert.assertTrue((boolean)transaction.isOpen());
        Assert.assertEquals((Object)Transaction.State.ACTIVE, (Object)transaction.state());
        Assert.assertTrue((boolean)((Boolean)transaction.prepare(updates).join()));
        Assert.assertEquals((Object)Transaction.State.PREPARED, (Object)transaction.state());
        try {
            transaction.begin();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{asyncMap});
    }

    @Test
    public void testCoordinatedMapTransaction() throws Exception {
        ArrayList<Object> mocks = new ArrayList<Object>();
        HashMap<PartitionId, DefaultTransactionalMapParticipant> participants = new HashMap<PartitionId, DefaultTransactionalMapParticipant>();
        ArrayList<PartitionId> sortedParticipants = new ArrayList<PartitionId>();
        TransactionId transactionId = TransactionId.from((String)UUID.randomUUID().toString());
        for (int i = 1; i <= 3; ++i) {
            AsyncConsistentMap asyncMap = (AsyncConsistentMap)EasyMock.mock(AsyncConsistentMap.class);
            mocks.add(asyncMap);
            TestConsistentMap consistentMap = new TestConsistentMap();
            Transaction transaction = new Transaction(transactionId, (Transactional)asyncMap);
            PartitionId partitionId = PartitionId.from((int)i);
            participants.put(partitionId, new DefaultTransactionalMapParticipant(consistentMap, transaction));
            sortedParticipants.add(partitionId);
        }
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)1))).transaction.transactionalObject.begin((TransactionId)EasyMock.anyObject(TransactionId.class))).andReturn(CompletableFuture.completedFuture(new Version(1L)));
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)1))).transaction.transactionalObject.prepare(new TransactionLog(transactionId, 1L, Arrays.asList(MapUpdate.newBuilder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey((Object)"foo").withVersion(1L).build(), MapUpdate.newBuilder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey((Object)"baz").withVersion(2L).build())))).andReturn(CompletableFuture.completedFuture(true));
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)1))).transaction.transactionalObject.commit(transactionId)).andReturn(CompletableFuture.completedFuture(null));
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)3))).transaction.transactionalObject.begin((TransactionId)EasyMock.anyObject(TransactionId.class))).andReturn(CompletableFuture.completedFuture(new Version(1L)));
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)3))).transaction.transactionalObject.prepare(new TransactionLog(transactionId, 1L, Arrays.asList(MapUpdate.newBuilder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey((Object)"bar").withValue((Object)"baz").withVersion(1L).build())))).andReturn(CompletableFuture.completedFuture(true));
        EasyMock.expect((Object)((DefaultTransactionalMapParticipant)participants.get((Object)PartitionId.from((int)3))).transaction.transactionalObject.commit(transactionId)).andReturn(CompletableFuture.completedFuture(null));
        TransactionManager transactionManager = (TransactionManager)EasyMock.mock(TransactionManager.class);
        EasyMock.expect((Object)transactionManager.updateState((TransactionId)EasyMock.anyObject(TransactionId.class), (Transaction.State)EasyMock.anyObject(Transaction.State.class))).andReturn(CompletableFuture.completedFuture(null)).anyTimes();
        EasyMock.expect((Object)transactionManager.remove((TransactionId)EasyMock.anyObject(TransactionId.class))).andReturn(CompletableFuture.completedFuture(null)).anyTimes();
        mocks.add(transactionManager);
        TransactionCoordinator transactionCoordinator = new TransactionCoordinator(transactionId, transactionManager);
        Hasher hasher = key -> {
            int hashCode = Hashing.sha256().hashBytes(key.getBytes()).asInt();
            return (PartitionId)sortedParticipants.get(Math.abs(hashCode) % sortedParticipants.size());
        };
        EasyMock.expect((Object)transactionManager.getTransactionalMap(EasyMock.anyString(), (Serializer)EasyMock.anyObject(), (TransactionCoordinator)EasyMock.anyObject())).andReturn((Object)new PartitionedTransactionalMap(participants, hasher));
        EasyMock.replay((Object[])mocks.toArray());
        PartitionedTransactionalMap transactionalMap = (PartitionedTransactionalMap)transactionCoordinator.getTransactionalMap("foo", Serializer.using((KryoNamespace)KryoNamespaces.API));
        ((TransactionalMapParticipant)transactionalMap.partitions.get((Object)PartitionId.from((int)1))).backingMap.put((Object)"foo", (Object)"bar");
        ((TransactionalMapParticipant)transactionalMap.partitions.get((Object)PartitionId.from((int)1))).backingMap.put((Object)"baz", (Object)"foo");
        Assert.assertTrue((boolean)transactionalMap.containsKey((Object)"foo"));
        Assert.assertEquals((Object)"bar", (Object)transactionalMap.remove((Object)"foo"));
        Assert.assertFalse((boolean)transactionalMap.containsKey((Object)"bar"));
        TestCase.assertNull((Object)transactionalMap.put((Object)"bar", (Object)"baz"));
        Assert.assertTrue((boolean)transactionalMap.containsKey((Object)"bar"));
        Assert.assertTrue((boolean)transactionalMap.containsKey((Object)"baz"));
        Assert.assertFalse((boolean)transactionalMap.remove((Object)"baz", (Object)"baz"));
        Assert.assertTrue((boolean)transactionalMap.remove((Object)"baz", (Object)"foo"));
        Assert.assertFalse((boolean)transactionalMap.containsKey((Object)"baz"));
        Assert.assertEquals((Object)CommitStatus.SUCCESS, transactionCoordinator.commit().join());
        EasyMock.verify((Object[])mocks.toArray());
    }

    private static class TestConsistentMap<K, V>
    implements ConsistentMap<K, V> {
        private final Map<K, Versioned<V>> map = new HashMap<K, Versioned<V>>();
        private final AtomicLong version = new AtomicLong();

        private TestConsistentMap() {
        }

        public String name() {
            return null;
        }

        public DistributedPrimitive.Type primitiveType() {
            return DistributedPrimitive.Type.CONSISTENT_MAP;
        }

        private long nextVersion() {
            return this.version.incrementAndGet();
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean containsKey(K key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(V value) {
            return this.map.containsValue(value);
        }

        public Versioned<V> get(K key) {
            return this.map.get(key);
        }

        public Versioned<V> getOrDefault(K key, V defaultValue) {
            return this.map.getOrDefault(key, new Versioned(defaultValue, 0L));
        }

        public Versioned<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        public Versioned<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        public Versioned<V> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        public Versioned<V> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        public Versioned<V> put(K key, V value) {
            return this.map.put(key, new Versioned(value, this.nextVersion()));
        }

        public Versioned<V> putAndGet(K key, V value) {
            return this.put(key, value);
        }

        public Versioned<V> remove(K key) {
            return this.map.remove(key);
        }

        public void clear() {
            this.map.clear();
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Collection<Versioned<V>> values() {
            return this.map.values();
        }

        public Set<Map.Entry<K, Versioned<V>>> entrySet() {
            return this.map.entrySet();
        }

        public Versioned<V> putIfAbsent(K key, V value) {
            return this.map.putIfAbsent(key, new Versioned(value, this.nextVersion()));
        }

        public boolean remove(K key, V value) {
            return this.map.remove(key, value);
        }

        public boolean remove(K key, long version) {
            Versioned<V> value = this.map.get(key);
            if (value != null && value.version() == version) {
                this.map.remove(key);
                return true;
            }
            return false;
        }

        public Versioned<V> replace(K key, V value) {
            return this.map.replace(key, new Versioned(value, this.nextVersion()));
        }

        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        public boolean replace(K key, long oldVersion, V newValue) {
            Versioned<V> value = this.map.get(key);
            if (value != null && value.version() == oldVersion) {
                this.map.put(key, new Versioned(newValue, this.nextVersion()));
                return true;
            }
            return false;
        }

        public void addListener(MapEventListener<K, V> listener, Executor executor) {
            throw new UnsupportedOperationException();
        }

        public void removeListener(MapEventListener<K, V> listener) {
            throw new UnsupportedOperationException();
        }

        public Map<K, V> asJavaMap() {
            throw new UnsupportedOperationException();
        }
    }
}

