/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.PartitionId;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.primitives.impl.CopycatTransportClient;
import org.onosproject.store.primitives.impl.CopycatTransportServer;

public class CopycatTransport
implements Transport {
    private final PartitionId partitionId;
    private final MessagingService messagingService;
    private static final Map<Address, Endpoint> EP_LOOKUP_CACHE = Maps.newConcurrentMap();
    static final byte MESSAGE = 1;
    static final byte CONNECT = 2;
    static final byte CLOSE = 3;
    static final byte SUCCESS = 1;
    static final byte FAILURE = 2;

    public CopycatTransport(PartitionId partitionId, MessagingService messagingService) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService, (Object)"messagingService cannot be null");
    }

    public Client client() {
        return new CopycatTransportClient(this.partitionId, this.messagingService);
    }

    public Server server() {
        return new CopycatTransportServer(this.partitionId, this.messagingService);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    static Endpoint toEndpoint(Address address) {
        return EP_LOOKUP_CACHE.computeIfAbsent(address, a -> {
            try {
                return new Endpoint(IpAddress.valueOf((InetAddress)InetAddress.getByName(a.host())), a.port());
            }
            catch (UnknownHostException e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        });
    }
}

