/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class DefaultDistributedDocumentTree<V>
implements AsyncDocumentTree<V> {
    private final String name;
    private final AsyncDocumentTree<byte[]> backingTree;
    private final Serializer serializer;
    private final Map<DocumentTreeListener<V>, InternalBackingDocumentTreeListener> listeners = Maps.newIdentityHashMap();

    DefaultDistributedDocumentTree(String name, AsyncDocumentTree<byte[]> backingTree, Serializer serializer) {
        this.name = name;
        this.backingTree = backingTree;
        this.serializer = serializer;
    }

    public String name() {
        return this.name;
    }

    public DistributedPrimitive.Type primitiveType() {
        return this.backingTree.primitiveType();
    }

    public DocumentPath root() {
        return this.backingTree.root();
    }

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath path) {
        return this.backingTree.getChildren(path).thenApply(map -> Maps.transformValues((Map)map, v -> v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0))));
    }

    public CompletableFuture<Versioned<V>> get(DocumentPath path) {
        return this.backingTree.get(path).thenApply(v -> v == null ? null : v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    public CompletableFuture<Versioned<V>> set(DocumentPath path, V value) {
        return this.backingTree.set(path, (Object)this.serializer.encode(value)).thenApply(v -> v == null ? null : v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    public CompletableFuture<Boolean> create(DocumentPath path, V value) {
        return this.backingTree.create(path, (Object)this.serializer.encode(value));
    }

    public CompletableFuture<Boolean> createRecursive(DocumentPath path, V value) {
        return this.backingTree.createRecursive(path, (Object)this.serializer.encode(value));
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, long version) {
        return this.backingTree.replace(path, (Object)this.serializer.encode(newValue), version);
    }

    public CompletableFuture<Boolean> replace(DocumentPath path, V newValue, V currentValue) {
        return this.backingTree.replace(path, (Object)this.serializer.encode(newValue), (Object)this.serializer.encode(currentValue));
    }

    public CompletableFuture<Versioned<V>> removeNode(DocumentPath path) {
        return this.backingTree.removeNode(path).thenApply(v -> v == null ? null : v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeListener<V> listener) {
        Map<DocumentTreeListener<V>, InternalBackingDocumentTreeListener> map = this.listeners;
        synchronized (map) {
            InternalBackingDocumentTreeListener backingListener = this.listeners.computeIfAbsent(listener, k -> new InternalBackingDocumentTreeListener(listener));
            return this.backingTree.addListener(path, (DocumentTreeListener)backingListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> removeListener(DocumentTreeListener<V> listener) {
        Map<DocumentTreeListener<V>, InternalBackingDocumentTreeListener> map = this.listeners;
        synchronized (map) {
            InternalBackingDocumentTreeListener backingListener = this.listeners.remove(listener);
            if (backingListener != null) {
                return this.backingTree.removeListener((DocumentTreeListener)backingListener);
            }
            return CompletableFuture.completedFuture(null);
        }
    }

    private class InternalBackingDocumentTreeListener
    implements DocumentTreeListener<byte[]> {
        private final DocumentTreeListener<V> listener;

        InternalBackingDocumentTreeListener(DocumentTreeListener<V> listener) {
            this.listener = listener;
        }

        public void event(DocumentTreeEvent<byte[]> event) {
            this.listener.event(new DocumentTreeEvent(event.path(), event.type(), event.newValue().map(v -> v.map(arg_0 -> ((Serializer)DefaultDistributedDocumentTree.this.serializer).decode(arg_0))), event.oldValue().map(v -> v.map(arg_0 -> ((Serializer)DefaultDistributedDocumentTree.this.serializer).decode(arg_0)))));
        }
    }
}

