/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;

public class DefaultDistributedWorkQueue<E>
implements WorkQueue<E> {
    private final WorkQueue<byte[]> backingQueue;
    private final Serializer serializer;

    public DefaultDistributedWorkQueue(WorkQueue<byte[]> backingQueue, Serializer serializer) {
        this.backingQueue = backingQueue;
        this.serializer = serializer;
    }

    public String name() {
        return this.backingQueue.name();
    }

    public CompletableFuture<Void> addMultiple(Collection<E> items) {
        return this.backingQueue.addMultiple((Collection)items.stream().map(arg_0 -> ((Serializer)this.serializer).encode(arg_0)).collect(Collectors.toCollection(ArrayList::new)));
    }

    private Collection<Task<E>> decodeCollection(Collection<Task<byte[]>> tasks) {
        return Collections2.transform(tasks, task -> task.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    public CompletableFuture<Collection<Task<E>>> take(int maxTasks) {
        return this.backingQueue.take(maxTasks).thenApply(this::decodeCollection);
    }

    public CompletableFuture<Void> complete(Collection<String> ids) {
        return this.backingQueue.complete(ids);
    }

    public CompletableFuture<WorkQueueStats> stats() {
        return this.backingQueue.stats();
    }

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> callback, int parallelism, Executor executor) {
        Consumer<byte[]> backingQueueCallback = payload -> callback.accept(this.serializer.decode(payload));
        return this.backingQueue.registerTaskProcessor(backingQueueCallback, parallelism, executor);
    }

    public CompletableFuture<Void> stopProcessing() {
        return this.backingQueue.stopProcessing();
    }

    public CompletableFuture<Void> destroy() {
        return this.backingQueue.destroy();
    }
}

