/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncAtomicValue;
import org.onosproject.store.service.AtomicValueEventListener;
import org.onosproject.store.service.DistributedPrimitive;

public class ExecutingAsyncAtomicValue<V>
extends ExecutingDistributedPrimitive
implements AsyncAtomicValue<V> {
    private final AsyncAtomicValue<V> delegateValue;
    private final Executor orderedExecutor;
    private final Map<AtomicValueEventListener<V>, AtomicValueEventListener<V>> listenerMap = Maps.newConcurrentMap();

    public ExecutingAsyncAtomicValue(AsyncAtomicValue<V> delegateValue, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateValue, orderedExecutor, threadPoolExecutor);
        this.delegateValue = delegateValue;
        this.orderedExecutor = orderedExecutor;
    }

    public CompletableFuture<Boolean> compareAndSet(V expect, V update) {
        return this.asyncFuture(this.delegateValue.compareAndSet(expect, update));
    }

    public CompletableFuture<V> get() {
        return this.asyncFuture(this.delegateValue.get());
    }

    public CompletableFuture<V> getAndSet(V value) {
        return this.asyncFuture(this.delegateValue.getAndSet(value));
    }

    public CompletableFuture<Void> set(V value) {
        return this.asyncFuture(this.delegateValue.set(value));
    }

    public CompletableFuture<Void> addListener(AtomicValueEventListener<V> listener) {
        AtomicValueEventListener wrappedListener = e -> this.orderedExecutor.execute(() -> listener.event(e));
        this.listenerMap.put(listener, wrappedListener);
        return this.asyncFuture(this.delegateValue.addListener(wrappedListener));
    }

    public CompletableFuture<Void> removeListener(AtomicValueEventListener<V> listener) {
        AtomicValueEventListener<V> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            return this.asyncFuture(this.delegateValue.removeListener(wrappedListener));
        }
        return CompletableFuture.completedFuture(null);
    }
}

