/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.ExecutingDistributedPrimitive;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;
import org.onosproject.store.service.Versioned;

public class ExecutingAsyncConsistentMap<K, V>
extends ExecutingDistributedPrimitive
implements AsyncConsistentMap<K, V> {
    private final AsyncConsistentMap<K, V> delegateMap;

    public ExecutingAsyncConsistentMap(AsyncConsistentMap<K, V> delegateMap, Executor orderedExecutor, Executor threadPoolExecutor) {
        super((DistributedPrimitive)delegateMap, orderedExecutor, threadPoolExecutor);
        this.delegateMap = delegateMap;
    }

    public CompletableFuture<Integer> size() {
        return this.asyncFuture(this.delegateMap.size());
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.asyncFuture(this.delegateMap.containsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.asyncFuture(this.delegateMap.containsValue(value));
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        return this.asyncFuture(this.delegateMap.get(key));
    }

    public CompletableFuture<Versioned<V>> getOrDefault(K key, V defaultValue) {
        return this.asyncFuture(this.delegateMap.getOrDefault(key, defaultValue));
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.asyncFuture(this.delegateMap.computeIf(key, condition, remappingFunction));
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        return this.asyncFuture(this.delegateMap.put(key, value));
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        return this.asyncFuture(this.delegateMap.putAndGet(key, value));
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        return this.asyncFuture(this.delegateMap.remove(key));
    }

    public CompletableFuture<Void> clear() {
        return this.asyncFuture(this.delegateMap.clear());
    }

    public CompletableFuture<Set<K>> keySet() {
        return this.asyncFuture(this.delegateMap.keySet());
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        return this.asyncFuture(this.delegateMap.values());
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        return this.asyncFuture(this.delegateMap.entrySet());
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        return this.asyncFuture(this.delegateMap.putIfAbsent(key, value));
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.asyncFuture(this.delegateMap.remove(key, value));
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return this.asyncFuture(this.delegateMap.remove(key, version));
    }

    public CompletableFuture<Versioned<V>> replace(K key, V value) {
        return this.asyncFuture(this.delegateMap.replace(key, value));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.asyncFuture(this.delegateMap.replace(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return this.asyncFuture(this.delegateMap.replace(key, oldVersion, newValue));
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.begin(transactionId));
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, V>> transactionLog) {
        return this.asyncFuture(this.delegateMap.prepare(transactionLog));
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.commit(transactionId));
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        return this.asyncFuture(this.delegateMap.rollback(transactionId));
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<K, V>> transactionLog) {
        return this.asyncFuture(this.delegateMap.prepareAndCommit(transactionLog));
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener) {
        return this.addListener(listener);
    }

    public CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        return this.asyncFuture(this.delegateMap.addListener(listener, executor));
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        return this.asyncFuture(this.delegateMap.removeListener(listener));
    }
}

