/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.impl.DelegatingDistributedPrimitive;
import org.onosproject.store.service.DistributedPrimitive;

public abstract class ExecutingDistributedPrimitive
extends DelegatingDistributedPrimitive {
    private final DistributedPrimitive primitive;
    private final Executor orderedExecutor;
    private final Executor threadPoolExecutor;
    private final Map<Consumer<DistributedPrimitive.Status>, Consumer<DistributedPrimitive.Status>> listenerMap = Maps.newConcurrentMap();

    protected ExecutingDistributedPrimitive(DistributedPrimitive primitive, Executor orderedExecutor, Executor threadPoolExecutor) {
        super(primitive);
        this.primitive = primitive;
        this.orderedExecutor = (Executor)Preconditions.checkNotNull((Object)orderedExecutor);
        this.threadPoolExecutor = (Executor)Preconditions.checkNotNull((Object)threadPoolExecutor);
    }

    protected <T> CompletableFuture<T> asyncFuture(CompletableFuture<T> future) {
        return Tools.orderedFuture(future, (Executor)this.orderedExecutor, (Executor)this.threadPoolExecutor);
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.asyncFuture(this.primitive.destroy());
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        Consumer<DistributedPrimitive.Status> wrappedListener = status -> this.orderedExecutor.execute(() -> listener.accept((DistributedPrimitive.Status)status));
        this.listenerMap.put(listener, wrappedListener);
        this.primitive.addStatusChangeListener(wrappedListener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        Consumer<DistributedPrimitive.Status> wrappedListener = this.listenerMap.remove(listener);
        if (wrappedListener != null) {
            this.primitive.removeStatusChangeListener(wrappedListener);
        }
    }
}

