/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.onlab.util.Tools;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.primitives.impl.PartitionedTransactionalMap;
import org.onosproject.store.primitives.impl.Transaction;
import org.onosproject.store.primitives.impl.TransactionManager;
import org.onosproject.store.primitives.impl.TransactionParticipant;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.TransactionalMap;

public class TransactionCoordinator {
    protected final TransactionId transactionId;
    protected final TransactionManager transactionManager;
    protected final Set<TransactionParticipant> transactionParticipants = Sets.newConcurrentHashSet();

    public TransactionCoordinator(TransactionId transactionId, TransactionManager transactionManager) {
        this.transactionId = transactionId;
        this.transactionManager = transactionManager;
    }

    public <K, V> TransactionalMap<K, V> getTransactionalMap(String name, Serializer serializer) {
        PartitionedTransactionalMap map = this.transactionManager.getTransactionalMap(name, serializer, this);
        this.transactionParticipants.addAll(map.participants());
        return map;
    }

    public CompletableFuture<CommitStatus> commit() {
        long totalParticipants = this.transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).count();
        if (totalParticipants == 0L) {
            return CompletableFuture.completedFuture(CommitStatus.SUCCESS);
        }
        if (totalParticipants == 1L) {
            return this.transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).findFirst().get().prepareAndCommit().thenApply(v -> v != false ? CommitStatus.SUCCESS : CommitStatus.FAILURE);
        }
        Set transactionParticipants = this.transactionParticipants.stream().filter(TransactionParticipant::hasPendingUpdates).collect(Collectors.toSet());
        CompletionStage status = ((CompletableFuture)this.transactionManager.updateState(this.transactionId, Transaction.State.PREPARING).thenCompose(v -> this.prepare(transactionParticipants))).thenCompose(result -> result != false ? ((CompletableFuture)this.transactionManager.updateState(this.transactionId, Transaction.State.COMMITTING).thenCompose(v -> this.commit(transactionParticipants))).thenApply(v -> CommitStatus.SUCCESS) : ((CompletableFuture)this.transactionManager.updateState(this.transactionId, Transaction.State.ROLLING_BACK).thenCompose(v -> this.rollback(transactionParticipants))).thenApply(v -> CommitStatus.FAILURE));
        return ((CompletableFuture)status).thenCompose(v -> this.transactionManager.remove(this.transactionId).thenApply(u -> v));
    }

    protected CompletableFuture<Boolean> prepare(Set<TransactionParticipant> transactionParticipants) {
        return Tools.allOf(transactionParticipants.stream().map(TransactionParticipant::prepare).collect(Collectors.toList())).thenApply(list -> list.stream().reduce(Boolean::logicalAnd).orElse(true));
    }

    protected CompletableFuture<Void> commit(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().map(TransactionParticipant::commit).toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<Void> rollback(Set<TransactionParticipant> transactionParticipants) {
        return CompletableFuture.allOf((CompletableFuture[])transactionParticipants.stream().map(TransactionParticipant::rollback).toArray(CompletableFuture[]::new));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("transactionId", (Object)this.transactionId).add("participants", this.transactionParticipants).toString();
    }
}

