/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.resource.ResourceStateMachine;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.onlab.util.CountDownCompleter;
import org.onlab.util.Match;
import org.onosproject.store.primitives.resources.impl.AtomixConsistentMultimapCommands;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixConsistentSetMultimapState
extends ResourceStateMachine
implements SessionListener,
Snapshottable {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicLong globalVersion = new AtomicLong(1L);
    private final Map<String, MapEntryValue> backingMap = Maps.newHashMap();

    public AtomixConsistentSetMultimapState(Properties properties) {
        super(properties);
    }

    public void snapshot(SnapshotWriter writer) {
    }

    public void install(SnapshotReader reader) {
    }

    protected void configure(StateMachineExecutor executor) {
        executor.register(AtomixConsistentMultimapCommands.Size.class, this::size);
        executor.register(AtomixConsistentMultimapCommands.IsEmpty.class, this::isEmpty);
        executor.register(AtomixConsistentMultimapCommands.ContainsKey.class, this::containsKey);
        executor.register(AtomixConsistentMultimapCommands.ContainsValue.class, this::containsValue);
        executor.register(AtomixConsistentMultimapCommands.ContainsEntry.class, this::containsEntry);
        executor.register(AtomixConsistentMultimapCommands.Clear.class, this::clear);
        executor.register(AtomixConsistentMultimapCommands.KeySet.class, this::keySet);
        executor.register(AtomixConsistentMultimapCommands.Keys.class, this::keys);
        executor.register(AtomixConsistentMultimapCommands.Values.class, this::values);
        executor.register(AtomixConsistentMultimapCommands.Entries.class, this::entries);
        executor.register(AtomixConsistentMultimapCommands.Get.class, this::get);
        executor.register(AtomixConsistentMultimapCommands.RemoveAll.class, this::removeAll);
        executor.register(AtomixConsistentMultimapCommands.MultiRemove.class, this::multiRemove);
        executor.register(AtomixConsistentMultimapCommands.Put.class, this::put);
        executor.register(AtomixConsistentMultimapCommands.Replace.class, this::replace);
    }

    protected int size(Commit<? extends AtomixConsistentMultimapCommands.Size> commit) {
        try {
            int n = this.backingMap.values().stream().map(valueCollection -> valueCollection.values().size()).collect(Collectors.summingInt(size -> size));
            return n;
        }
        finally {
            commit.close();
        }
    }

    protected boolean isEmpty(Commit<? extends AtomixConsistentMultimapCommands.IsEmpty> commit) {
        try {
            boolean bl = this.backingMap.isEmpty();
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected boolean containsKey(Commit<? extends AtomixConsistentMultimapCommands.ContainsKey> commit) {
        try {
            boolean bl = this.backingMap.containsKey(((AtomixConsistentMultimapCommands.ContainsKey)commit.operation()).key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsValue(Commit<? extends AtomixConsistentMultimapCommands.ContainsValue> commit) {
        try {
            if (this.backingMap.values().isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Match match = Match.ifValue((Object)((AtomixConsistentMultimapCommands.ContainsValue)commit.operation()).value());
            boolean bl = this.backingMap.values().stream().anyMatch(valueList -> valueList.values().stream().anyMatch(byteValue -> match.matches(byteValue)));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsEntry(Commit<? extends AtomixConsistentMultimapCommands.ContainsEntry> commit) {
        try {
            MapEntryValue entryValue = this.backingMap.get(((AtomixConsistentMultimapCommands.ContainsEntry)commit.operation()).key());
            if (entryValue == null) {
                boolean bl = false;
                return bl;
            }
            Match valueMatch = Match.ifValue((Object)((AtomixConsistentMultimapCommands.ContainsEntry)commit.operation()).value());
            boolean bl = entryValue.values().stream().anyMatch(byteValue -> valueMatch.matches(byteValue));
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected void clear(Commit<? extends AtomixConsistentMultimapCommands.Clear> commit) {
        try {
            this.backingMap.clear();
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> keySet(Commit<? extends AtomixConsistentMultimapCommands.KeySet> commit) {
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(this.backingMap.keySet());
            return immutableSet;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Multiset<String> keys(Commit<? extends AtomixConsistentMultimapCommands.Keys> commit) {
        try {
            HashMultiset keys = HashMultiset.create();
            this.backingMap.forEach((arg_0, arg_1) -> AtomixConsistentSetMultimapState.lambda$keys$5((Multiset)keys, arg_0, arg_1));
            HashMultiset hashMultiset = keys;
            return hashMultiset;
        }
        finally {
            commit.close();
        }
    }

    protected Multiset<byte[]> values(Commit<? extends AtomixConsistentMultimapCommands.Values> commit) {
        try {
            Multiset multiset = (Multiset)this.backingMap.values().stream().collect(new HashMultisetValueCollector());
            return multiset;
        }
        finally {
            commit.close();
        }
    }

    protected Collection<Map.Entry<String, byte[]>> entries(Commit<? extends AtomixConsistentMultimapCommands.Entries> commit) {
        try {
            Collection collection = this.backingMap.entrySet().stream().collect(new EntrySetCollector());
            return collection;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Versioned<Collection<? extends byte[]>> get(Commit<? extends AtomixConsistentMultimapCommands.Get> commit) {
        try {
            MapEntryValue mapEntryValue = this.backingMap.get(((AtomixConsistentMultimapCommands.Get)commit.operation()).key());
            Versioned<Collection<? extends byte[]>> versioned = this.toVersioned(this.backingMap.get(((AtomixConsistentMultimapCommands.Get)commit.operation()).key()));
            return versioned;
        }
        finally {
            commit.close();
        }
    }

    protected Versioned<Collection<? extends byte[]>> removeAll(Commit<? extends AtomixConsistentMultimapCommands.RemoveAll> commit) {
        if (!this.backingMap.containsKey(((AtomixConsistentMultimapCommands.RemoveAll)commit.operation()).key())) {
            commit.close();
            return new Versioned((Object)Sets.newHashSet(), -1L);
        }
        return this.backingMap.get(((AtomixConsistentMultimapCommands.RemoveAll)commit.operation()).key()).addCommit(commit);
    }

    protected boolean multiRemove(Commit<? extends AtomixConsistentMultimapCommands.MultiRemove> commit) {
        if (!this.backingMap.containsKey(((AtomixConsistentMultimapCommands.MultiRemove)commit.operation()).key())) {
            commit.close();
            return false;
        }
        return this.backingMap.get(((AtomixConsistentMultimapCommands.MultiRemove)commit.operation()).key()).addCommit(commit) != null;
    }

    protected boolean put(Commit<? extends AtomixConsistentMultimapCommands.Put> commit) {
        if (((AtomixConsistentMultimapCommands.Put)commit.operation()).values().isEmpty()) {
            return false;
        }
        if (!this.backingMap.containsKey(((AtomixConsistentMultimapCommands.Put)commit.operation()).key())) {
            this.backingMap.put(((AtomixConsistentMultimapCommands.Put)commit.operation()).key(), new NonTransactionalCommit(1L));
        }
        return this.backingMap.get(((AtomixConsistentMultimapCommands.Put)commit.operation()).key()).addCommit(commit) != null;
    }

    protected Versioned<Collection<? extends byte[]>> replace(Commit<? extends AtomixConsistentMultimapCommands.Replace> commit) {
        if (!this.backingMap.containsKey(((AtomixConsistentMultimapCommands.Replace)commit.operation()).key())) {
            this.backingMap.put(((AtomixConsistentMultimapCommands.Replace)commit.operation()).key(), new NonTransactionalCommit(1L));
        }
        return this.backingMap.get(((AtomixConsistentMultimapCommands.Replace)commit.operation()).key()).addCommit(commit);
    }

    private Versioned<Collection<? extends byte[]>> toVersioned(MapEntryValue value) {
        return value == null ? new Versioned((Object)Lists.newArrayList(), -1L) : new Versioned(value.values(), value.version());
    }

    private static /* synthetic */ void lambda$keys$5(Multiset keys, String key, MapEntryValue mapEntryValue) {
        keys.add((Object)key, mapEntryValue.values().size());
    }

    private class ByteArrayComparator
    implements Comparator<byte[]> {
        private ByteArrayComparator() {
        }

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (Arrays.equals(o1, o2)) {
                return 0;
            }
            for (int i = 0; i < o1.length && i < o2.length; ++i) {
                if (o1[i] < o2[i]) {
                    return -1;
                }
                if (o1[i] <= o2[i]) continue;
                return 1;
            }
            return o1.length > o2.length ? 1 : -1;
        }
    }

    private class EntrySetCollector
    implements Collector<Map.Entry<String, MapEntryValue>, Set<Map.Entry<String, byte[]>>, Set<Map.Entry<String, byte[]>>> {
        private Set<Map.Entry<String, byte[]>> set = null;

        private EntrySetCollector() {
        }

        @Override
        public Supplier<Set<Map.Entry<String, byte[]>>> supplier() {
            return () -> {
                if (this.set == null) {
                    this.set = Sets.newHashSet();
                }
                return this.set;
            };
        }

        @Override
        public BiConsumer<Set<Map.Entry<String, byte[]>>, Map.Entry<String, MapEntryValue>> accumulator() {
            return (set, entry) -> ((MapEntryValue)entry.getValue()).values().forEach(byteValue -> set.add(Maps.immutableEntry(entry.getKey(), (Object)byteValue)));
        }

        @Override
        public BinaryOperator<Set<Map.Entry<String, byte[]>>> combiner() {
            return (setOne, setTwo) -> {
                setOne.addAll(setTwo);
                return setOne;
            };
        }

        @Override
        public Function<Set<Map.Entry<String, byte[]>>, Set<Map.Entry<String, byte[]>>> finisher() {
            return unused -> this.set;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    private class HashMultisetValueCollector
    implements Collector<MapEntryValue, HashMultiset<byte[]>, HashMultiset<byte[]>> {
        private HashMultiset<byte[]> multiset = null;

        private HashMultisetValueCollector() {
        }

        @Override
        public Supplier<HashMultiset<byte[]>> supplier() {
            return () -> {
                if (this.multiset == null) {
                    this.multiset = HashMultiset.create();
                }
                return this.multiset;
            };
        }

        @Override
        public BiConsumer<HashMultiset<byte[]>, MapEntryValue> accumulator() {
            return (multiset, mapEntryValue) -> multiset.addAll(mapEntryValue.values());
        }

        @Override
        public BinaryOperator<HashMultiset<byte[]>> combiner() {
            return (setOne, setTwo) -> {
                setOne.addAll((Collection)setTwo);
                return setOne;
            };
        }

        @Override
        public Function<HashMultiset<byte[]>, HashMultiset<byte[]>> finisher() {
            return unused -> this.multiset;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED);
        }
    }

    private class NonTransactionalCommit
    implements MapEntryValue {
        private long version;
        private final TreeMap<byte[], CountDownCompleter<Commit>> valueCountdownMap;
        private final HashMultimap<Commit, CountDownCompleter<Commit>> additiveToRemovalCommits;

        public NonTransactionalCommit(long version) {
            this.valueCountdownMap = Maps.newTreeMap((Comparator)new ByteArrayComparator());
            this.additiveToRemovalCommits = HashMultimap.create();
            this.version = AtomixConsistentSetMultimapState.this.globalVersion.get();
        }

        @Override
        public Collection<? extends byte[]> values() {
            return ImmutableSet.copyOf(this.valueCountdownMap.keySet());
        }

        @Override
        public long version() {
            return this.version;
        }

        @Override
        public void discard() {
            this.valueCountdownMap.values().forEach(completer -> ((Commit)completer.object()).close());
        }

        @Override
        public Versioned<Collection<? extends byte[]>> addCommit(Commit<? extends AtomixConsistentMultimapCommands.MultimapCommand> commit) {
            Preconditions.checkNotNull(commit);
            Preconditions.checkNotNull((Object)commit.operation());
            if (commit.operation() instanceof AtomixConsistentMultimapCommands.Put) {
                TreeSet valuesToAdd = Sets.newTreeSet((Comparator)new ByteArrayComparator());
                ((AtomixConsistentMultimapCommands.Put)commit.operation()).values().forEach(value -> {
                    if (!this.valueCountdownMap.containsKey(value)) {
                        valuesToAdd.add(value);
                    }
                });
                if (valuesToAdd.isEmpty()) {
                    commit.close();
                    return null;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)valuesToAdd.size(), c -> {
                    if (this.additiveToRemovalCommits.containsKey(c)) {
                        this.additiveToRemovalCommits.get(c).forEach(countdown -> countdown.countDown());
                        this.additiveToRemovalCommits.removeAll(c);
                    }
                    c.close();
                });
                Versioned retVersion = new Versioned((Object)valuesToAdd, this.version);
                valuesToAdd.forEach(value -> this.valueCountdownMap.put((byte[])value, (CountDownCompleter<Commit>)completer));
                ++this.version;
                return retVersion;
            }
            if (commit.operation() instanceof AtomixConsistentMultimapCommands.Replace) {
                HashSet removedValues = Sets.newHashSet();
                removedValues.addAll(this.valueCountdownMap.keySet());
                Versioned retVersion = new Versioned((Object)removedValues, this.version);
                this.valueCountdownMap.values().forEach(countdown -> countdown.countDown());
                this.valueCountdownMap.clear();
                TreeSet valuesToAdd = Sets.newTreeSet((Comparator)new ByteArrayComparator());
                ((AtomixConsistentMultimapCommands.Replace)commit.operation()).values().forEach(value -> valuesToAdd.add(value));
                if (valuesToAdd.isEmpty()) {
                    this.version = AtomixConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                    AtomixConsistentSetMultimapState.this.backingMap.remove(((AtomixConsistentMultimapCommands.Replace)commit.operation()).key());
                    commit.close();
                    return retVersion;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)valuesToAdd.size(), c -> {
                    if (this.additiveToRemovalCommits.containsKey(c)) {
                        this.additiveToRemovalCommits.get(c).forEach(countdown -> countdown.countDown());
                        this.additiveToRemovalCommits.removeAll(c);
                    }
                    c.close();
                });
                valuesToAdd.forEach(value -> this.valueCountdownMap.put((byte[])value, (CountDownCompleter<Commit>)completer));
                this.version = AtomixConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                return retVersion;
            }
            if (commit.operation() instanceof AtomixConsistentMultimapCommands.RemoveAll) {
                HashSet removed = Sets.newHashSet();
                removed.addAll(this.valueCountdownMap.keySet());
                Versioned retVersion = new Versioned((Object)removed, this.version);
                this.valueCountdownMap.values().forEach(countdown -> countdown.countDown());
                this.valueCountdownMap.clear();
                String key = ((AtomixConsistentMultimapCommands.RemoveAll)commit.operation()).key();
                commit.close();
                this.version = AtomixConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                AtomixConsistentSetMultimapState.this.backingMap.remove(key);
                return retVersion;
            }
            if (commit.operation() instanceof AtomixConsistentMultimapCommands.MultiRemove) {
                HashSet removed = Sets.newHashSet();
                HashSet commitsRemovedFrom = Sets.newHashSet();
                ((AtomixConsistentMultimapCommands.MultiRemove)commit.operation()).values().forEach(value -> {
                    if (this.valueCountdownMap.containsKey(value)) {
                        removed.add(value);
                        commitsRemovedFrom.add(this.valueCountdownMap.get(value).object());
                    }
                });
                if (removed.isEmpty()) {
                    commit.close();
                    return null;
                }
                CountDownCompleter completer = new CountDownCompleter(commit, (long)commitsRemovedFrom.size(), c -> c.close());
                commitsRemovedFrom.forEach(commitRemovedFrom -> this.additiveToRemovalCommits.put(commitRemovedFrom, (Object)completer));
                String removedKey = ((AtomixConsistentMultimapCommands.MultiRemove)commit.operation()).key();
                removed.forEach(removedValue -> this.valueCountdownMap.remove(removedValue).countDown());
                Versioned retVersion = new Versioned((Object)removed, this.version);
                this.version = AtomixConsistentSetMultimapState.this.globalVersion.incrementAndGet();
                if (this.valueCountdownMap.isEmpty()) {
                    AtomixConsistentSetMultimapState.this.backingMap.remove(removedKey);
                }
                return retVersion;
            }
            throw new IllegalArgumentException();
        }
    }

    private static interface MapEntryValue {
        public Collection<? extends byte[]> values();

        public long version();

        public void discard();

        public Versioned<Collection<? extends byte[]>> addCommit(Commit<? extends AtomixConsistentMultimapCommands.MultimapCommand> var1);
    }
}

