/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives.resources.impl;

import com.google.common.base.MoreObjects;
import org.onosproject.store.service.DocumentPath;
import org.onosproject.store.service.Versioned;

public class DocumentTreeUpdateResult<V> {
    private final DocumentPath path;
    private final Status status;
    private final Versioned<V> oldValue;
    private final Versioned<V> newValue;

    public DocumentTreeUpdateResult(DocumentPath path, Status status, Versioned<V> newValue, Versioned<V> oldValue) {
        this.status = status;
        this.path = path;
        this.newValue = newValue;
        this.oldValue = oldValue;
    }

    public static <V> DocumentTreeUpdateResult<V> invalidPath(DocumentPath path) {
        return new DocumentTreeUpdateResult<V>(path, Status.INVALID_PATH, null, null);
    }

    public static <V> DocumentTreeUpdateResult<V> illegalModification(DocumentPath path) {
        return new DocumentTreeUpdateResult<V>(path, Status.ILLEGAL_MODIFICATION, null, null);
    }

    public Status status() {
        return this.status;
    }

    public DocumentPath path() {
        return this.path;
    }

    public Versioned<V> oldValue() {
        return this.oldValue;
    }

    public Versioned<V> newValue() {
        return this.newValue;
    }

    public boolean updated() {
        return this.status == Status.OK;
    }

    public boolean created() {
        return this.updated() && this.oldValue == null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("path", (Object)this.path).add("status", (Object)this.status).add("newValue", this.newValue).add("oldValue", this.oldValue).toString();
    }

    public static enum Status {
        OK,
        NOOP,
        WRITE_LOCK,
        INVALID_PATH,
        ILLEGAL_MODIFICATION;

    }
}

