/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.utils.event.EventListener;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.Node;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.Version;
import org.onosproject.core.VersionService;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.atomix.impl.AtomixManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ClusterStore.class})
public class AtomixClusterStore
extends AbstractStore<ClusterEvent, ClusterStoreDelegate>
implements ClusterStore {
    private static final String INSTANCE_ID_NULL = "Instance ID cannot be null";
    private static final String STATE_KEY = "state";
    private static final String VERSION_KEY = "version";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected AtomixManager atomixManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected VersionService versionService;
    private ClusterMembershipService membershipService;
    private ControllerNode localNode;
    private final Map<NodeId, ControllerNode> nodes = Maps.newConcurrentMap();
    private final Map<NodeId, ControllerNode.State> states = Maps.newConcurrentMap();
    private final Map<NodeId, Version> versions = Maps.newConcurrentMap();
    private final Map<NodeId, Instant> updates = Maps.newConcurrentMap();
    private final ClusterMembershipEventListener membershipEventListener = this::changeMembership;

    @Activate
    public void activate() {
        this.membershipService = this.atomixManager.getAtomix().getMembershipService();
        this.membershipService.addListener((EventListener)this.membershipEventListener);
        this.membershipService.getMembers().forEach(member -> {
            ControllerNode node = this.toControllerNode((Member)member);
            this.nodes.put(node.id(), node);
            this.updateState(node, (Member)member);
            this.updateVersion(node, (Member)member);
        });
        this.membershipService.getLocalMember().properties().put(STATE_KEY, ControllerNode.State.ACTIVE.name());
        this.membershipService.getLocalMember().properties().put(VERSION_KEY, this.versionService.version().toString());
        this.localNode = this.toControllerNode(this.membershipService.getLocalMember());
        this.states.put(this.localNode.id(), ControllerNode.State.ACTIVE);
        this.versions.put(this.localNode.id(), this.versionService.version());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.membershipService.removeListener((EventListener)this.membershipEventListener);
        this.log.info("Stopped");
    }

    private void changeMembership(ClusterMembershipEvent event) {
        ControllerNode node = this.nodes.get(NodeId.nodeId((String)((String)((Object)((Member)event.subject()).id().id()))));
        switch ((ClusterMembershipEvent.Type)event.type()) {
            case MEMBER_ADDED: 
            case METADATA_CHANGED: {
                if (node == null) {
                    node = this.toControllerNode((Member)event.subject());
                    this.nodes.put(node.id(), node);
                    this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node));
                }
                this.updateVersion(node, (Member)event.subject());
                this.updateState(node, (Member)event.subject());
                break;
            }
            case MEMBER_REMOVED: {
                if (node == null || this.states.put(node.id(), ControllerNode.State.INACTIVE) == ControllerNode.State.INACTIVE) break;
                this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, node));
                this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, node));
                break;
            }
        }
    }

    private void updateState(ControllerNode node, Member member) {
        String state = member.properties().getProperty(STATE_KEY);
        if (state == null || !state.equals(ControllerNode.State.READY.name())) {
            if (this.states.put(node.id(), ControllerNode.State.ACTIVE) != ControllerNode.State.ACTIVE) {
                this.log.info("Updated node {} state to {}", (Object)node.id(), (Object)ControllerNode.State.ACTIVE);
                this.markUpdated(node.id());
                this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, node));
            }
        } else if (this.states.put(node.id(), ControllerNode.State.READY) != ControllerNode.State.READY) {
            this.log.info("Updated node {} state to {}", (Object)node.id(), (Object)ControllerNode.State.READY);
            this.markUpdated(node.id());
            this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, node));
        }
    }

    private void updateVersion(ControllerNode node, Member member) {
        String versionString = member.properties().getProperty(VERSION_KEY);
        if (versionString != null) {
            Version version = Version.version((String)versionString);
            if (!Objects.equals(this.versions.put(node.id(), version), version)) {
                this.log.info("Updated node {} version to {}", (Object)node.id(), (Object)version);
            }
        }
    }

    private void markUpdated(NodeId nodeId) {
        this.updates.put(nodeId, Instant.now());
    }

    private ControllerNode toControllerNode(Member member) {
        return new DefaultControllerNode(NodeId.nodeId((String)((String)((Object)member.id().id()))), member.address().host(), member.address().port());
    }

    public ControllerNode getLocalNode() {
        return this.localNode;
    }

    public Set<Node> getStorageNodes() {
        return this.membershipService.getMembers().stream().filter(member -> !Objects.equals(member.properties().getProperty("type"), "onos")).map(this::toControllerNode).collect(Collectors.toSet());
    }

    public Set<ControllerNode> getNodes() {
        return this.membershipService.getMembers().stream().filter(member -> Objects.equals(member.properties().getProperty("type"), "onos")).map(this::toControllerNode).collect(Collectors.toSet());
    }

    public ControllerNode getNode(NodeId nodeId) {
        Member member = this.membershipService.getMember((String)nodeId.id());
        return member != null ? this.toControllerNode(member) : null;
    }

    public ControllerNode.State getState(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.states.get(nodeId);
    }

    public Version getVersion(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.versions.get(nodeId);
    }

    public Instant getLastUpdatedInstant(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.updates.get(nodeId);
    }

    public void markFullyStarted(boolean started) {
        ControllerNode.State state = started ? ControllerNode.State.READY : ControllerNode.State.ACTIVE;
        this.membershipService.getLocalMember().properties().setProperty(STATE_KEY, state.name());
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        DefaultControllerNode node = new DefaultControllerNode(nodeId, ip, tcpPort);
        this.nodes.put(node.id(), (ControllerNode)node);
        ControllerNode.State state = node.equals(this.localNode) ? ControllerNode.State.ACTIVE : ControllerNode.State.INACTIVE;
        this.membershipService.getMember((String)node.id().id()).properties().setProperty(STATE_KEY, state.name());
        this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, (ControllerNode)node));
        return node;
    }

    public void removeNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        ControllerNode node = this.nodes.remove(nodeId);
        if (node != null) {
            this.states.remove(nodeId);
            this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, node));
        }
    }
}

