/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.core.transaction.AsyncTransaction;
import io.atomix.core.transaction.TransactionalMap;
import io.atomix.core.transaction.TransactionalMapBuilder;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.onosproject.store.atomix.primitives.impl.AtomixSerializerAdapter;
import org.onosproject.store.atomix.primitives.impl.AtomixTransactionalMap;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.CommitStatus;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.TransactionContext;

public class AtomixTransactionContext
implements TransactionContext {
    private static final int MAX_RETRIES = 5;
    private final AsyncTransaction atomixTransaction;
    private final String group;

    public AtomixTransactionContext(AsyncTransaction atomixTransaction, String group) {
        this.atomixTransaction = atomixTransaction;
        this.group = group;
    }

    public String name() {
        return this.atomixTransaction.name();
    }

    public TransactionId transactionId() {
        return TransactionId.from((String)((String)((Object)this.atomixTransaction.transactionId().id())));
    }

    public boolean isOpen() {
        return this.atomixTransaction.isOpen();
    }

    public void begin() {
        try {
            this.atomixTransaction.begin().get(15000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException.Unavailable();
        }
    }

    public CompletableFuture<CommitStatus> commit() {
        return this.atomixTransaction.commit().thenApply(status -> CommitStatus.valueOf((String)status.name()));
    }

    public void abort() {
        try {
            this.atomixTransaction.abort().get(15000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException.Unavailable();
        }
    }

    public <K, V> org.onosproject.store.service.TransactionalMap<K, V> getTransactionalMap(String mapName, Serializer serializer) {
        return new AtomixTransactionalMap((TransactionalMap)((TransactionalMapBuilder)this.atomixTransaction.mapBuilder(mapName).withProtocol((ProxyProtocol)MultiRaftProtocol.builder((String)this.group).withRecoveryStrategy(Recovery.RECOVER).withMaxRetries(5).build()).withSerializer((io.atomix.utils.serializer.Serializer)new AtomixSerializerAdapter(serializer))).get());
    }
}

