/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.Atomix;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.core.counter.AtomicCounterType;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapBuilder;
import io.atomix.core.map.AtomicMapType;
import io.atomix.core.workqueue.WorkQueueStats;
import io.atomix.core.workqueue.WorkQueueType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Member;
import org.onosproject.cluster.MembershipService;
import org.onosproject.cluster.Node;
import org.onosproject.cluster.NodeId;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.atomix.impl.AtomixManager;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicCounterBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicCounterMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicIdGeneratorBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicValueBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentMultimapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentTreeMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDistributedLockBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDistributedSetBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDistributedTopicBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDocumentTreeBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixLeaderElectorBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixSerializerAdapter;
import org.onosproject.store.atomix.primitives.impl.AtomixTransactionContextBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixWorkQueueBuilder;
import org.onosproject.store.atomix.primitives.impl.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.AtomicCounterMapBuilder;
import org.onosproject.store.service.AtomicIdGeneratorBuilder;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMultimapBuilder;
import org.onosproject.store.service.ConsistentTreeMapBuilder;
import org.onosproject.store.service.DistributedLockBuilder;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.DocumentTreeBuilder;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.MapInfo;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Topic;
import org.onosproject.store.service.TopicBuilder;
import org.onosproject.store.service.TransactionContextBuilder;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueBuilder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={StorageService.class, StorageAdminService.class})
public class StorageManager
implements StorageService,
StorageAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected PersistenceService persistenceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected PartitionAdminService partitionAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected MembershipService membershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected AtomixManager atomixManager;
    private Atomix atomix;
    private PartitionGroup group;

    @Activate
    public void activate() {
        this.atomix = this.atomixManager.getAtomix();
        this.group = this.atomix.getPartitionService().getPartitionGroup((PrimitiveProtocol.Type)MultiRaftProtocol.TYPE);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public <K, V> EventuallyConsistentMapBuilder<K, V> eventuallyConsistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        MembershipService membershipService = this.membershipService;
        ClusterService clusterService = this.clusterService;
        NodeId localNodeId = clusterService.getLocalNode().id();
        Supplier<List<NodeId>> peersSupplier = () -> membershipService.getMembers().stream().map(Member::nodeId).filter(nodeId -> !nodeId.equals((Object)localNodeId)).filter(id -> clusterService.getState(id).isActive()).collect(Collectors.toList());
        Supplier<List<NodeId>> bootstrapPeersSupplier = () -> {
            if (membershipService.getMembers().size() == 1) {
                return clusterService.getNodes().stream().map(Node::id).filter(id -> !localNodeId.equals(id)).filter(id -> clusterService.getState(id).isActive()).collect(Collectors.toList());
            }
            return membershipService.getMembers().stream().map(Member::nodeId).filter(id -> !localNodeId.equals(id)).filter(id -> clusterService.getState(id).isActive()).collect(Collectors.toList());
        };
        return new EventuallyConsistentMapBuilderImpl(localNodeId, this.clusterCommunicator, this.persistenceService, peersSupplier, bootstrapPeersSupplier);
    }

    public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixConsistentMapBuilder(this.atomix, this.group.name());
    }

    public <V> DocumentTreeBuilder<V> documentTreeBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDocumentTreeBuilder(this.atomix, this.group.name());
    }

    public <V> ConsistentTreeMapBuilder<V> consistentTreeMapBuilder() {
        return new AtomixConsistentTreeMapBuilder(this.atomix, this.group.name());
    }

    public <K, V> ConsistentMultimapBuilder<K, V> consistentMultimapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixConsistentMultimapBuilder(this.atomix, this.group.name());
    }

    public <K> AtomicCounterMapBuilder<K> atomicCounterMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicCounterMapBuilder(this.atomix, this.group.name());
    }

    public <E> DistributedSetBuilder<E> setBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDistributedSetBuilder(this.atomix, this.group.name());
    }

    public AtomicCounterBuilder atomicCounterBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicCounterBuilder(this.atomix, this.group.name());
    }

    public AtomicIdGeneratorBuilder atomicIdGeneratorBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicIdGeneratorBuilder(this.atomix, this.group.name());
    }

    public <V> AtomicValueBuilder<V> atomicValueBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicValueBuilder(this.atomix, this.group.name());
    }

    public TransactionContextBuilder transactionContextBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixTransactionContextBuilder(this.atomix, this.group.name());
    }

    public DistributedLockBuilder lockBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDistributedLockBuilder(this.atomix, this.group.name());
    }

    public LeaderElectorBuilder leaderElectorBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixLeaderElectorBuilder(this.atomix, this.group.name(), this.clusterService.getLocalNode().id());
    }

    public <T> TopicBuilder<T> topicBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDistributedTopicBuilder(this.atomix, this.group.name());
    }

    public <E> WorkQueueBuilder<E> workQueueBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixWorkQueueBuilder(this.atomix, this.group.name());
    }

    public <E> WorkQueue<E> getWorkQueue(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (WorkQueue)((WorkQueueBuilder)((WorkQueueBuilder)this.workQueueBuilder().withName(name)).withSerializer(serializer)).build();
    }

    public <V> AsyncDocumentTree<V> getDocumentTree(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (AsyncDocumentTree)((DocumentTreeBuilder)((DocumentTreeBuilder)this.documentTreeBuilder().withName(name)).withSerializer(serializer)).build();
    }

    public <K, V> AsyncConsistentMultimap<K, V> getAsyncSetMultimap(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return ((ConsistentMultimapBuilder)((ConsistentMultimapBuilder)new AtomixConsistentMultimapBuilder(this.atomix, this.group.name()).withName(name)).withSerializer(serializer)).buildMultimap();
    }

    public <V> AsyncConsistentTreeMap<V> getAsyncTreeMap(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return ((ConsistentTreeMapBuilder)((ConsistentTreeMapBuilder)this.consistentTreeMapBuilder().withName(name)).withSerializer(serializer)).buildTreeMap();
    }

    public <T> Topic<T> getTopic(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (Topic)((TopicBuilder)((TopicBuilder)this.topicBuilder().withName(name)).withSerializer(serializer)).build();
    }

    public List<MapInfo> getMapInfo() {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);
        return this.atomix.getPrimitives((PrimitiveType)AtomicMapType.instance()).stream().map(info -> {
            AtomicMap map = (AtomicMap)((AtomicMapBuilder)this.atomix.atomicMapBuilder(info.name()).withSerializer((io.atomix.utils.serializer.Serializer)new AtomixSerializerAdapter(serializer))).build();
            int size = map.size();
            map.close();
            return new MapInfo(info.name(), size);
        }).collect(Collectors.toList());
    }

    public Map<String, Long> getCounters() {
        return this.atomix.getPrimitives((PrimitiveType)AtomicCounterType.instance()).stream().map(info -> {
            AtomicCounter counter = (AtomicCounter)this.atomix.atomicCounterBuilder(info.name()).build();
            long value = counter.get();
            counter.close();
            return Maps.immutableEntry((Object)info.name(), (Object)value);
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Long)e.getValue()));
    }

    public Map<String, org.onosproject.store.service.WorkQueueStats> getQueueStats() {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.BASIC);
        return this.atomix.getPrimitives((PrimitiveType)WorkQueueType.instance()).stream().map(info -> {
            io.atomix.core.workqueue.WorkQueue queue = (io.atomix.core.workqueue.WorkQueue)((io.atomix.core.workqueue.WorkQueueBuilder)this.atomix.workQueueBuilder(info.name()).withSerializer((io.atomix.utils.serializer.Serializer)new AtomixSerializerAdapter(serializer))).build();
            WorkQueueStats stats = queue.stats();
            return Maps.immutableEntry((Object)info.name(), (Object)org.onosproject.store.service.WorkQueueStats.builder().withTotalCompleted(stats.totalCompleted()).withTotalInProgress(stats.totalInProgress()).withTotalPending(stats.totalPending()).build());
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (org.onosproject.store.service.WorkQueueStats)e.getValue()));
    }

    public Collection<TransactionId> getPendingTransactions() {
        return this.atomix.getTransactionService().getActiveTransactions().stream().map(transactionId -> TransactionId.from((String)((String)((Object)transactionId.id())))).collect(Collectors.toList());
    }
}

