/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.value.AsyncAtomicValue;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.AtomicValueEvent;
import org.onosproject.store.service.AtomicValueEventListener;

public class AtomixAtomicValue<V>
implements org.onosproject.store.service.AsyncAtomicValue<V> {
    private final AsyncAtomicValue<V> atomixValue;
    private final Map<AtomicValueEventListener<V>, io.atomix.core.value.AtomicValueEventListener<V>> listenerMap = Maps.newIdentityHashMap();

    public AtomixAtomicValue(AsyncAtomicValue<V> atomixValue) {
        this.atomixValue = atomixValue;
    }

    public String name() {
        return this.atomixValue.name();
    }

    public CompletableFuture<Boolean> compareAndSet(V expect, V update) {
        return AtomixFutures.adaptFuture(this.atomixValue.compareAndSet(expect, update));
    }

    public CompletableFuture<V> get() {
        return AtomixFutures.adaptFuture(this.atomixValue.get());
    }

    public CompletableFuture<V> getAndSet(V value) {
        return AtomixFutures.adaptFuture(this.atomixValue.getAndSet(value));
    }

    public CompletableFuture<Void> set(V value) {
        return AtomixFutures.adaptFuture(this.atomixValue.set(value));
    }

    public synchronized CompletableFuture<Void> addListener(AtomicValueEventListener<V> listener) {
        io.atomix.core.value.AtomicValueEventListener atomixListener = event -> listener.event(new AtomicValueEvent(this.name(), event.newValue(), event.oldValue()));
        this.listenerMap.put(listener, atomixListener);
        return AtomixFutures.adaptFuture(this.atomixValue.addListener(atomixListener));
    }

    public synchronized CompletableFuture<Void> removeListener(AtomicValueEventListener<V> listener) {
        io.atomix.core.value.AtomicValueEventListener<V> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return AtomixFutures.adaptFuture(this.atomixValue.removeListener(atomixListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> destroy() {
        return AtomixFutures.adaptFuture(this.atomixValue.delete());
    }
}

