/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.MessagingService;
import io.atomix.utils.net.Address;
import java.net.InetAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.onlab.packet.IpAddress;
import org.onosproject.store.atomix.impl.AtomixManager;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={org.onosproject.store.cluster.messaging.MessagingService.class})
public class AtomixMessagingManager
implements org.onosproject.store.cluster.messaging.MessagingService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected AtomixManager atomixManager;
    private MessagingService messagingService;

    @Activate
    public void activate() {
        this.messagingService = this.atomixManager.getAtomix().getMessagingService();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private Address toAddress(Endpoint ep) {
        return new Address(ep.host().toString(), ep.port(), ep.host().toInetAddress());
    }

    private Endpoint toEndpoint(Address address) {
        return new Endpoint(IpAddress.valueOf((InetAddress)address.address()), address.port());
    }

    public CompletableFuture<Void> sendAsync(Endpoint ep, String type, byte[] payload) {
        return this.messagingService.sendAsync(this.toAddress(ep), type, payload);
    }

    public CompletableFuture<byte[]> sendAndReceive(Endpoint ep, String type, byte[] payload, Duration timeout, Executor executor) {
        return this.messagingService.sendAndReceive(this.toAddress(ep), type, payload, timeout, executor);
    }

    public void registerHandler(String type, BiConsumer<Endpoint, byte[]> handler, Executor executor) {
        BiConsumer<Address, byte[]> consumer = (address, payload) -> handler.accept(this.toEndpoint((Address)address), (byte[])payload);
        this.messagingService.registerHandler(type, consumer, executor);
    }

    public void registerHandler(String type, BiFunction<Endpoint, byte[], byte[]> handler, Executor executor) {
        BiFunction<Address, byte[], byte[]> function = (address, payload) -> (byte[])handler.apply(this.toEndpoint((Address)address), (byte[])payload);
        this.messagingService.registerHandler(type, function, executor);
    }

    public void registerHandler(String type, BiFunction<Endpoint, byte[], CompletableFuture<byte[]>> handler) {
        BiFunction<Address, byte[], CompletableFuture> function = (address, payload) -> (CompletableFuture)handler.apply(this.toEndpoint((Address)address), (byte[])payload);
        this.messagingService.registerHandler(type, function);
    }

    public void unregisterHandler(String type) {
        this.messagingService.unregisterHandler(type);
    }
}

