/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.core.Atomix;
import io.atomix.core.election.LeaderElector;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import java.time.Duration;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.atomix.primitives.impl.AtomixLeaderElector;
import org.onosproject.store.atomix.primitives.impl.AtomixSerializerAdapter;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.Serializer;

public class AtomixLeaderElectorBuilder
extends LeaderElectorBuilder {
    private static final int MAX_RETRIES = 5;
    private final Atomix atomix;
    private final String group;
    private final NodeId localNodeId;

    public AtomixLeaderElectorBuilder(Atomix atomix, String group, NodeId localNodeId) {
        this.atomix = atomix;
        this.group = group;
        this.localNodeId = localNodeId;
    }

    public AsyncLeaderElector build() {
        Serializer serializer = Serializer.using((KryoNamespace)KryoNamespaces.API);
        return new AtomixLeaderElector((io.atomix.core.election.AsyncLeaderElector<NodeId>)((LeaderElector)((io.atomix.core.election.LeaderElectorBuilder)((io.atomix.core.election.LeaderElectorBuilder)((io.atomix.core.election.LeaderElectorBuilder)this.atomix.leaderElectorBuilder(this.name()).withProtocol((ProxyProtocol)MultiRaftProtocol.builder((String)this.group).withRecoveryStrategy(Recovery.RECOVER).withMaxRetries(5).withMaxTimeout(Duration.ofMillis(this.electionTimeoutMillis())).build()).withReadOnly(this.readOnly())).withCacheEnabled(this.relaxedReadConsistency())).withSerializer((io.atomix.utils.serializer.Serializer)new AtomixSerializerAdapter(serializer))).build()).async(), this.localNodeId);
    }
}

