/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.set.impl.TranscodingAsyncDistributedSet;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.AsyncIterator;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;

public class AtomixConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final AsyncAtomicMap<K, V> atomixMap;
    private final Map<MapEventListener<K, V>, AtomicMapEventListener<K, V>> listenerMap = Maps.newIdentityHashMap();

    public AtomixConsistentMap(AsyncAtomicMap<K, V> atomixMap) {
        this.atomixMap = atomixMap;
    }

    public String name() {
        return this.atomixMap.name();
    }

    public CompletableFuture<Integer> size() {
        return this.atomixMap.size();
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return this.atomixMap.containsKey(key);
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.atomixMap.containsValue(value);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> get(K key) {
        return this.atomixMap.get(key).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> getOrDefault(K key, V defaultValue) {
        return this.atomixMap.getOrDefault(key, defaultValue).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.computeIf(key, condition, remappingFunction).thenApply(this::toVersioned));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> put(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.put(key, value).thenApply(this::toVersioned));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> putAndGet(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.putAndGet(key, value).thenApply(this::toVersioned));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> remove(K key) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.remove(key).thenApply(this::toVersioned));
    }

    public CompletableFuture<Void> clear() {
        return this.atomixMap.clear();
    }

    public CompletableFuture<Set<K>> keySet() {
        return CompletableFuture.completedFuture(this.atomixMap.keySet().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Collection<org.onosproject.store.service.Versioned<V>>> values() {
        return CompletableFuture.completedFuture(new TranscodingAsyncDistributedCollection(this.atomixMap.values(), v -> new Versioned(v.value(), v.version()), v -> new org.onosproject.store.service.Versioned(v.value(), v.version())).sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Set<Map.Entry<K, org.onosproject.store.service.Versioned<V>>>> entrySet() {
        return CompletableFuture.completedFuture(new TranscodingAsyncDistributedSet(this.atomixMap.entrySet(), e -> Maps.immutableEntry(e.getKey(), (Object)new Versioned(((org.onosproject.store.service.Versioned)e.getValue()).value(), ((org.onosproject.store.service.Versioned)e.getValue()).version())), e -> Maps.immutableEntry(e.getKey(), (Object)new org.onosproject.store.service.Versioned(((Versioned)e.getValue()).value(), ((Versioned)e.getValue()).version()))).sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> putIfAbsent(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.putIfAbsent(key, value).thenApply(this::toVersioned));
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.remove(key, value));
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.remove(key, version));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> replace(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.replace(key, value).thenApply(this::toVersioned));
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.replace(key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        return AtomixFutures.adaptMapFuture(this.atomixMap.replace(key, oldVersion, newValue));
    }

    public CompletableFuture<AsyncIterator<Map.Entry<K, org.onosproject.store.service.Versioned<V>>>> iterator() {
        final io.atomix.core.iterator.AsyncIterator atomixIterator = this.atomixMap.entrySet().iterator();
        return CompletableFuture.completedFuture(new AsyncIterator<Map.Entry<K, org.onosproject.store.service.Versioned<V>>>(){

            public CompletableFuture<Boolean> hasNext() {
                return atomixIterator.hasNext();
            }

            public CompletableFuture<Map.Entry<K, org.onosproject.store.service.Versioned<V>>> next() {
                return atomixIterator.next().thenApply(entry -> Maps.immutableEntry(entry.getKey(), AtomixConsistentMap.this.toVersioned((Versioned)entry.getValue())));
            }
        });
    }

    public synchronized CompletableFuture<Void> addListener(MapEventListener<K, V> listener, Executor executor) {
        AtomicMapEventListener atomixListener = event -> listener.event(new MapEvent(MapEvent.Type.valueOf((String)((AtomicMapEvent.Type)event.type()).name()), this.name(), event.key(), this.toVersioned(event.newValue()), this.toVersioned(event.oldValue())));
        this.listenerMap.put(listener, atomixListener);
        return this.atomixMap.addListener(atomixListener, executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<K, V> listener) {
        AtomicMapEventListener<K, V> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return this.atomixMap.removeListener(atomixListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<K, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<K, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    private org.onosproject.store.service.Versioned<V> toVersioned(Versioned<V> versioned) {
        return versioned != null ? new org.onosproject.store.service.Versioned(versioned.value(), versioned.version(), versioned.creationTime()) : null;
    }
}

