/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.core.Atomix;
import io.atomix.primitive.partition.PartitionGroup;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Node;
import org.onosproject.cluster.NodeId;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.atomix.impl.AtomixManager;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicCounterBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicCounterMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicIdGeneratorBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixAtomicValueBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentMultimapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixConsistentTreeMapBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDistributedSetBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDistributedTopicBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixDocumentTreeBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixLeaderElectorBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixTransactionContextBuilder;
import org.onosproject.store.atomix.primitives.impl.AtomixWorkQueueBuilder;
import org.onosproject.store.atomix.primitives.impl.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.AtomicCounterMapBuilder;
import org.onosproject.store.service.AtomicIdGeneratorBuilder;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMultimapBuilder;
import org.onosproject.store.service.ConsistentTreeMapBuilder;
import org.onosproject.store.service.CoordinationService;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.DocumentTreeBuilder;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Topic;
import org.onosproject.store.service.TopicBuilder;
import org.onosproject.store.service.TransactionContextBuilder;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueBuilder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CoordinationService.class})
public class CoordinationManager
implements CoordinationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected PersistenceService persistenceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected AtomixManager atomixManager;
    private Atomix atomix;
    private PartitionGroup group;

    @Activate
    public void activate() {
        this.atomix = this.atomixManager.getAtomix();
        this.group = this.atomix.getPartitionService().getSystemPartitionGroup();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public <K, V> EventuallyConsistentMapBuilder<K, V> eventuallyConsistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        NodeId localNodeId = this.clusterService.getLocalNode().id();
        Supplier<List<NodeId>> peersSupplier = () -> this.clusterService.getNodes().stream().map(Node::id).filter(nodeId -> !nodeId.equals((Object)localNodeId)).filter(id -> this.clusterService.getState(id).isActive()).collect(Collectors.toList());
        Supplier<List<NodeId>> bootstrapPeersSupplier = () -> this.clusterService.getNodes().stream().map(Node::id).filter(id -> !localNodeId.equals(id)).filter(id -> this.clusterService.getState(id).isActive()).collect(Collectors.toList());
        return new EventuallyConsistentMapBuilderImpl(localNodeId, this.clusterCommunicator, this.persistenceService, peersSupplier, bootstrapPeersSupplier);
    }

    public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixConsistentMapBuilder(this.atomix, this.group.name());
    }

    public <V> DocumentTreeBuilder<V> documentTreeBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDocumentTreeBuilder(this.atomix, this.group.name());
    }

    public <V> ConsistentTreeMapBuilder<V> consistentTreeMapBuilder() {
        return new AtomixConsistentTreeMapBuilder(this.atomix, this.group.name());
    }

    public <K, V> ConsistentMultimapBuilder<K, V> consistentMultimapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixConsistentMultimapBuilder(this.atomix, this.group.name());
    }

    public <K> AtomicCounterMapBuilder<K> atomicCounterMapBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicCounterMapBuilder(this.atomix, this.group.name());
    }

    public <E> DistributedSetBuilder<E> setBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDistributedSetBuilder(this.atomix, this.group.name());
    }

    public AtomicCounterBuilder atomicCounterBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicCounterBuilder(this.atomix, this.group.name());
    }

    public AtomicIdGeneratorBuilder atomicIdGeneratorBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicIdGeneratorBuilder(this.atomix, this.group.name());
    }

    public <V> AtomicValueBuilder<V> atomicValueBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixAtomicValueBuilder(this.atomix, this.group.name());
    }

    public TransactionContextBuilder transactionContextBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixTransactionContextBuilder(this.atomix, this.group.name());
    }

    public LeaderElectorBuilder leaderElectorBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixLeaderElectorBuilder(this.atomix, this.group.name(), this.clusterService.getLocalNode().id());
    }

    public <T> TopicBuilder<T> topicBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixDistributedTopicBuilder(this.atomix, this.group.name());
    }

    public <E> WorkQueueBuilder<E> workQueueBuilder() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return new AtomixWorkQueueBuilder(this.atomix, this.group.name());
    }

    public <E> WorkQueue<E> getWorkQueue(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (WorkQueue)((WorkQueueBuilder)((WorkQueueBuilder)this.workQueueBuilder().withName(name)).withSerializer(serializer)).build();
    }

    public <V> AsyncDocumentTree<V> getDocumentTree(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (AsyncDocumentTree)((DocumentTreeBuilder)((DocumentTreeBuilder)this.documentTreeBuilder().withName(name)).withSerializer(serializer)).build();
    }

    public <K, V> AsyncConsistentMultimap<K, V> getAsyncSetMultimap(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return ((ConsistentMultimapBuilder)((ConsistentMultimapBuilder)this.consistentMultimapBuilder().withName(name)).withSerializer(serializer)).buildMultimap();
    }

    public <V> AsyncConsistentTreeMap<V> getAsyncTreeMap(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return ((ConsistentTreeMapBuilder)((ConsistentTreeMapBuilder)this.consistentTreeMapBuilder().withName(name)).withSerializer(serializer)).buildTreeMap();
    }

    public <T> Topic<T> getTopic(String name, Serializer serializer) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.STORAGE_WRITE);
        return (Topic)((TopicBuilder)((TopicBuilder)this.topicBuilder().withName(name)).withSerializer(serializer)).build();
    }
}

