/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.tree.AsyncAtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEvent;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.utils.time.Versioned;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.primitives.NodeUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncDocumentTree;
import org.onosproject.store.service.DocumentTreeEvent;
import org.onosproject.store.service.DocumentTreeListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;

public class AtomixDocumentTree<V>
implements AsyncDocumentTree<V> {
    private final AsyncAtomicDocumentTree<V> atomixTree;
    private final Map<DocumentTreeListener<V>, DocumentTreeEventListener<V>> listenerMap = Maps.newIdentityHashMap();

    public AtomixDocumentTree(AsyncAtomicDocumentTree<V> atomixTree) {
        this.atomixTree = atomixTree;
    }

    public String name() {
        return this.atomixTree.name();
    }

    public org.onosproject.store.service.DocumentPath root() {
        return this.toOnosPath(this.atomixTree.root());
    }

    public CompletableFuture<Map<String, org.onosproject.store.service.Versioned<V>>> getChildren(org.onosproject.store.service.DocumentPath path) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.getChildren(this.toAtomixPath(path))).thenApply(map -> map.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.toVersioned((Versioned)e.getValue()))));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> get(org.onosproject.store.service.DocumentPath path) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.get(this.toAtomixPath(path))).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> set(org.onosproject.store.service.DocumentPath path, V value) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.set(this.toAtomixPath(path), value)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Boolean> create(org.onosproject.store.service.DocumentPath path, V value) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.create(this.toAtomixPath(path), value));
    }

    public CompletableFuture<Boolean> createRecursive(org.onosproject.store.service.DocumentPath path, V value) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.createRecursive(this.toAtomixPath(path), value));
    }

    public CompletableFuture<Boolean> replace(org.onosproject.store.service.DocumentPath path, V newValue, long version) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.replace(this.toAtomixPath(path), newValue, version));
    }

    public CompletableFuture<Boolean> replace(org.onosproject.store.service.DocumentPath path, V newValue, V currentValue) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.replace(this.toAtomixPath(path), newValue, currentValue));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> removeNode(org.onosproject.store.service.DocumentPath path) {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.remove(this.toAtomixPath(path))).thenApply(this::toVersioned);
    }

    public synchronized CompletableFuture<Void> addListener(org.onosproject.store.service.DocumentPath path, DocumentTreeListener<V> listener) {
        DocumentTreeEventListener atomixListener = event -> listener.event(new DocumentTreeEvent(this.toOnosPath(event.path()), DocumentTreeEvent.Type.valueOf((String)((DocumentTreeEvent.Type)event.type()).name()), event.newValue().map(this::toVersioned), event.oldValue().map(this::toVersioned)));
        this.listenerMap.put(listener, atomixListener);
        return AtomixFutures.adaptTreeFuture(this.atomixTree.addListener(this.toAtomixPath(path), atomixListener));
    }

    public CompletableFuture<Void> removeListener(DocumentTreeListener<V> listener) {
        DocumentTreeEventListener<V> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return AtomixFutures.adaptTreeFuture(this.atomixTree.removeListener(atomixListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<NodeUpdate<V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<NodeUpdate<V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> destroy() {
        return AtomixFutures.adaptTreeFuture(this.atomixTree.delete());
    }

    private org.onosproject.store.service.DocumentPath toOnosPath(DocumentPath path) {
        ArrayList pathElements = Lists.newArrayList((Iterable)path.pathElements());
        pathElements.set(0, (String)org.onosproject.store.service.DocumentPath.ROOT.pathElements().get(0));
        return org.onosproject.store.service.DocumentPath.from((List)pathElements);
    }

    private DocumentPath toAtomixPath(org.onosproject.store.service.DocumentPath path) {
        ArrayList pathElements = Lists.newArrayList((Iterable)path.pathElements());
        pathElements.remove(0);
        return DocumentPath.from((List)pathElements);
    }

    private org.onosproject.store.service.Versioned<V> toVersioned(Versioned<V> versioned) {
        return versioned != null ? new org.onosproject.store.service.Versioned(versioned.value(), versioned.version(), versioned.creationTime()) : null;
    }
}

