/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.base.Throwables;
import io.atomix.core.tree.IllegalDocumentModificationException;
import io.atomix.core.tree.NoSuchDocumentPathException;
import io.atomix.primitive.PrimitiveException;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.StorageException;

final class AtomixFutures {
    static <T> CompletableFuture<T> adaptFuture(CompletableFuture<T> future) {
        CompletableFuture newFuture = new CompletableFuture();
        future.whenComplete((result, error) -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (cause instanceof PrimitiveException.ConcurrentModification) {
                    newFuture.completeExceptionally((Throwable)new StorageException.ConcurrentModification());
                } else if (cause instanceof PrimitiveException.Timeout) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Timeout());
                } else if (cause instanceof PrimitiveException.Interrupted) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Interrupted());
                } else if (cause instanceof PrimitiveException.Unavailable) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Unavailable());
                } else if (cause instanceof PrimitiveException) {
                    newFuture.completeExceptionally((Throwable)new StorageException(cause.getMessage()));
                } else {
                    newFuture.completeExceptionally(cause);
                }
            }
        });
        return newFuture;
    }

    static <T> CompletableFuture<T> adaptMapFuture(CompletableFuture<T> future) {
        CompletableFuture newFuture = new CompletableFuture();
        future.whenComplete((result, error) -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (cause instanceof PrimitiveException.ConcurrentModification) {
                    newFuture.completeExceptionally((Throwable)new ConsistentMapException.ConcurrentModification(cause.getMessage()));
                } else if (cause instanceof PrimitiveException.Timeout) {
                    newFuture.completeExceptionally((Throwable)new ConsistentMapException.Timeout(cause.getMessage()));
                } else if (cause instanceof PrimitiveException.Interrupted) {
                    newFuture.completeExceptionally((Throwable)new ConsistentMapException.Interrupted());
                } else if (cause instanceof PrimitiveException.Unavailable) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Unavailable());
                } else if (cause instanceof PrimitiveException) {
                    newFuture.completeExceptionally((Throwable)new ConsistentMapException(cause.getMessage()));
                } else {
                    newFuture.completeExceptionally(cause);
                }
            }
        });
        return newFuture;
    }

    static <T> CompletableFuture<T> adaptTreeFuture(CompletableFuture<T> future) {
        CompletableFuture newFuture = new CompletableFuture();
        future.whenComplete((result, error) -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                Throwable cause = Throwables.getRootCause((Throwable)error);
                if (cause instanceof NoSuchDocumentPathException) {
                    newFuture.completeExceptionally((Throwable)new org.onosproject.store.service.NoSuchDocumentPathException());
                } else if (cause instanceof IllegalDocumentModificationException) {
                    newFuture.completeExceptionally((Throwable)new org.onosproject.store.service.IllegalDocumentModificationException());
                } else if (cause instanceof PrimitiveException.ConcurrentModification) {
                    newFuture.completeExceptionally((Throwable)new StorageException.ConcurrentModification());
                } else if (cause instanceof PrimitiveException.Timeout) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Timeout());
                } else if (cause instanceof PrimitiveException.Interrupted) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Interrupted());
                } else if (cause instanceof PrimitiveException.Unavailable) {
                    newFuture.completeExceptionally((Throwable)new StorageException.Unavailable());
                } else if (cause instanceof PrimitiveException) {
                    newFuture.completeExceptionally((Throwable)new StorageException(cause.getMessage()));
                } else {
                    newFuture.completeExceptionally(cause);
                }
            }
        });
        return newFuture;
    }

    private AtomixFutures() {
    }
}

