/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.election.LeadershipEventListener;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.AsyncLeaderElector;

public class AtomixLeaderElector
implements AsyncLeaderElector {
    private final io.atomix.core.election.AsyncLeaderElector<NodeId> atomixElector;
    private final NodeId localNodeId;
    private final Map<Consumer<Change<Leadership>>, LeadershipEventListener<NodeId>> listenerMap = Maps.newIdentityHashMap();

    public AtomixLeaderElector(io.atomix.core.election.AsyncLeaderElector<NodeId> atomixElector, NodeId localNodeId) {
        this.atomixElector = atomixElector;
        this.localNodeId = localNodeId;
    }

    public String name() {
        return this.atomixElector.name();
    }

    public CompletableFuture<Leadership> run(String topic, NodeId nodeId) {
        return AtomixFutures.adaptFuture(this.atomixElector.run(topic, (Object)nodeId)).thenApply(leadership -> this.toLeadership(topic, (io.atomix.core.election.Leadership<NodeId>)leadership));
    }

    public CompletableFuture<Void> withdraw(String topic) {
        return AtomixFutures.adaptFuture(this.atomixElector.withdraw(topic, (Object)this.localNodeId));
    }

    public CompletableFuture<Boolean> anoint(String topic, NodeId nodeId) {
        return AtomixFutures.adaptFuture(this.atomixElector.anoint(topic, (Object)nodeId));
    }

    public CompletableFuture<Void> evict(NodeId nodeId) {
        return AtomixFutures.adaptFuture(this.atomixElector.evict((Object)nodeId));
    }

    public CompletableFuture<Boolean> promote(String topic, NodeId nodeId) {
        return AtomixFutures.adaptFuture(this.atomixElector.promote(topic, (Object)nodeId));
    }

    public CompletableFuture<Leadership> getLeadership(String topic) {
        return AtomixFutures.adaptFuture(this.atomixElector.getLeadership(topic)).thenApply(leadership -> this.toLeadership(topic, (io.atomix.core.election.Leadership<NodeId>)leadership));
    }

    public CompletableFuture<Map<String, Leadership>> getLeaderships() {
        return AtomixFutures.adaptFuture(this.atomixElector.getLeaderships()).thenApply(leaderships -> leaderships.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> this.toLeadership((String)e.getKey(), (io.atomix.core.election.Leadership<NodeId>)((io.atomix.core.election.Leadership)e.getValue())))));
    }

    public CompletableFuture<Void> addChangeListener(Consumer<Change<Leadership>> consumer) {
        LeadershipEventListener atomixListener = event -> consumer.accept(new Change((Object)this.toLeadership(event.topic(), (io.atomix.core.election.Leadership<NodeId>)event.oldLeadership()), (Object)this.toLeadership(event.topic(), (io.atomix.core.election.Leadership<NodeId>)event.newLeadership())));
        this.listenerMap.put(consumer, (LeadershipEventListener<NodeId>)atomixListener);
        return AtomixFutures.adaptFuture(this.atomixElector.addListener(atomixListener));
    }

    public CompletableFuture<Void> removeChangeListener(Consumer<Change<Leadership>> consumer) {
        LeadershipEventListener<NodeId> atomixListener = this.listenerMap.remove(consumer);
        if (atomixListener != null) {
            return AtomixFutures.adaptFuture(this.atomixElector.removeListener(atomixListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    private Leadership toLeadership(String topic, io.atomix.core.election.Leadership<NodeId> leadership) {
        return leadership != null ? new Leadership(topic, this.toLeader((io.atomix.core.election.Leader<NodeId>)leadership.leader()), leadership.candidates()) : null;
    }

    private Leader toLeader(io.atomix.core.election.Leader<NodeId> leader) {
        return leader != null ? new Leader((NodeId)leader.id(), leader.term(), leader.timestamp()) : null;
    }
}

