/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import io.atomix.core.map.impl.TranscodingAsyncDistributedMap;
import io.atomix.core.multimap.AsyncAtomicMultimap;
import io.atomix.core.multimap.AtomicMultimapEventListener;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.atomix.primitives.impl.AtomixIterator;
import org.onosproject.store.service.AsyncConsistentMultimap;
import org.onosproject.store.service.AsyncIterator;
import org.onosproject.store.service.MultimapEvent;
import org.onosproject.store.service.MultimapEventListener;

public class AtomixConsistentMultimap<K, V>
implements AsyncConsistentMultimap<K, V> {
    private final AsyncAtomicMultimap<K, V> atomixMultimap;
    private final Map<MultimapEventListener<K, V>, AtomicMultimapEventListener<K, V>> listenerMap = Maps.newIdentityHashMap();

    public AtomixConsistentMultimap(AsyncAtomicMultimap<K, V> atomixMultimap) {
        this.atomixMultimap = atomixMultimap;
    }

    public String name() {
        return this.atomixMultimap.name();
    }

    public CompletableFuture<Integer> size() {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.size());
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.containsKey(key));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.containsValue(value));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.isEmpty());
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.containsEntry(key, value));
    }

    public CompletableFuture<Boolean> put(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.put(key, value));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<Collection<? extends V>>> putAndGet(K key, V value) {
        return AtomixFutures.adaptMapFuture(((CompletableFuture)this.atomixMultimap.put(key, value).thenCompose(v -> this.atomixMultimap.get(key))).thenApply(this::toVersioned));
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.remove(key, value));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<Collection<? extends V>>> removeAndGet(K key, V value) {
        return AtomixFutures.adaptMapFuture(((CompletableFuture)this.atomixMultimap.remove(key, value).thenCompose(v -> this.atomixMultimap.get(key))).thenApply(this::toVersioned));
    }

    public CompletableFuture<Boolean> removeAll(K key, Collection<? extends V> values) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.removeAll(key, values));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<Collection<? extends V>>> removeAll(K key) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.removeAll(key).thenApply(this::toVersioned));
    }

    public CompletableFuture<Boolean> putAll(K key, Collection<? extends V> values) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.putAll(key, values));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<Collection<? extends V>>> replaceValues(K key, Collection<V> values) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.replaceValues(key, values).thenApply(this::toVersioned));
    }

    public CompletableFuture<Void> clear() {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.clear());
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<Collection<? extends V>>> get(K key) {
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.get(key).thenApply(this::toVersioned));
    }

    public CompletableFuture<Set<K>> keySet() {
        return CompletableFuture.completedFuture(this.atomixMultimap.keySet().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Multiset<K>> keys() {
        return CompletableFuture.completedFuture(this.atomixMultimap.keys().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Multiset<V>> values() {
        return CompletableFuture.completedFuture(this.atomixMultimap.values().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Collection<Map.Entry<K, V>>> entries() {
        return CompletableFuture.completedFuture(this.atomixMultimap.entries().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<AsyncIterator<Map.Entry<K, V>>> iterator() {
        return CompletableFuture.completedFuture(new AtomixIterator(this.atomixMultimap.entries().iterator()));
    }

    public CompletableFuture<Map<K, Collection<V>>> asMap() {
        return CompletableFuture.completedFuture(new TranscodingAsyncDistributedMap(this.atomixMultimap.asMap(), Function.identity(), Function.identity(), v -> new Versioned(v, 0L), v -> (Collection)v.value()).sync(Duration.ofMillis(15000L)));
    }

    public synchronized CompletableFuture<Void> addListener(MultimapEventListener<K, V> listener, Executor executor) {
        AtomicMultimapEventListener atomixListener = event -> listener.event(new MultimapEvent(this.name(), event.key(), event.newValue(), event.oldValue()));
        this.listenerMap.put(listener, atomixListener);
        return AtomixFutures.adaptMapFuture(this.atomixMultimap.addListener(atomixListener, executor));
    }

    public CompletableFuture<Void> removeListener(MultimapEventListener<K, V> listener) {
        AtomicMultimapEventListener<K, V> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return AtomixFutures.adaptMapFuture(this.atomixMultimap.removeListener(atomixListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    private org.onosproject.store.service.Versioned<Collection<? extends V>> toVersioned(Versioned<Collection<V>> versioned) {
        return versioned != null ? new org.onosproject.store.service.Versioned((Object)((Collection)versioned.value()), versioned.version(), versioned.creationTime()) : null;
    }
}

