/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.PartitionId;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.EventSink;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.onosproject.store.atomix.impl.AtomixManager;
import org.onosproject.store.primitives.PartitionAdminService;
import org.onosproject.store.primitives.PartitionEvent;
import org.onosproject.store.primitives.PartitionEventListener;
import org.onosproject.store.primitives.PartitionService;
import org.onosproject.store.service.PartitionClientInfo;
import org.onosproject.store.service.PartitionInfo;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PartitionService.class, PartitionAdminService.class})
public class PartitionManager
extends AbstractListenerManager<PartitionEvent, PartitionEventListener>
implements PartitionService,
PartitionAdminService {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected AtomixManager atomixManager;
    private PartitionGroup partitionGroup;

    @Activate
    public void activate() {
        this.partitionGroup = this.atomixManager.getAtomix().getPartitionService().getPartitionGroup((PrimitiveProtocol.Type)MultiRaftProtocol.TYPE);
        this.eventDispatcher.addSink(PartitionEvent.class, (EventSink)this.listenerRegistry);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(PartitionEvent.class);
        this.log.info("Stopped");
    }

    public int getNumberOfPartitions() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitionGroup.getPartitions().size();
    }

    public Set<PartitionId> getAllPartitionIds() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitionGroup.getPartitionIds().stream().map(partitionId -> PartitionId.from((int)((Integer)partitionId.id()))).collect(Collectors.toSet());
    }

    public Set<NodeId> getConfiguredMembers(PartitionId partitionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        io.atomix.primitive.partition.PartitionId atomixPartitionId = io.atomix.primitive.partition.PartitionId.from((String)this.partitionGroup.name(), (int)((Integer)partitionId.id()));
        return this.partitionGroup.getPartition(atomixPartitionId).members().stream().map(member -> NodeId.nodeId((String)((String)((Object)member.id())))).collect(Collectors.toSet());
    }

    public List<PartitionInfo> partitionInfo() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitionGroup.getPartitions().stream().map(partition -> {
            MemberId primary = partition.primary();
            return new PartitionInfo(PartitionId.from((int)((Integer)partition.id().id())), partition.term(), partition.members().stream().map(member -> (String)((Object)member.id())).collect(Collectors.toList()), primary != null ? (String)((Object)primary.id()) : null);
        }).collect(Collectors.toList());
    }

    public List<PartitionClientInfo> partitionClientInfo() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        return this.partitionGroup.getPartitions().stream().map(partition -> new PartitionClientInfo(PartitionId.from((int)((Integer)partition.id().id())), (Collection)partition.members().stream().map(member -> NodeId.nodeId((String)((String)((Object)member.id())))).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public void snapshot() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        if (this.partitionGroup != null) {
            this.partitionGroup.snapshot().join();
        }
    }

    public void snapshot(PartitionId partitionId) {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PARTITION_READ);
        io.atomix.primitive.partition.PartitionId atomixPartitionId = io.atomix.primitive.partition.PartitionId.from((String)this.partitionGroup.name(), (int)((Integer)partitionId.id()));
        if (this.partitionGroup != null && this.partitionGroup.getPartition(atomixPartitionId) != null) {
            this.partitionGroup.snapshot(atomixPartitionId).join();
        }
    }
}

