/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValueEventListener;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Topic;

public class AtomixDistributedTopic<T>
implements Topic<T> {
    private final AsyncAtomicValue<T> atomixValue;
    private final Map<Consumer<T>, AtomicValueEventListener<T>> callbacks = Maps.newIdentityHashMap();

    AtomixDistributedTopic(AsyncAtomicValue<T> atomixValue) {
        this.atomixValue = atomixValue;
    }

    public String name() {
        return this.atomixValue.name();
    }

    public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.TOPIC;
    }

    public CompletableFuture<Void> publish(T message) {
        return AtomixFutures.adaptFuture(this.atomixValue.set(message));
    }

    public CompletableFuture<Void> subscribe(Consumer<T> callback, Executor executor) {
        AtomicValueEventListener valueListener = event -> executor.execute(() -> callback.accept(event.newValue()));
        if (this.callbacks.putIfAbsent(callback, valueListener) == null) {
            return AtomixFutures.adaptFuture(this.atomixValue.addListener(valueListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> unsubscribe(Consumer<T> callback) {
        AtomicValueEventListener<T> valueListener = this.callbacks.remove(callback);
        if (valueListener != null) {
            return AtomixFutures.adaptFuture(this.atomixValue.removeListener(valueListener));
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> destroy() {
        return this.atomixValue.close();
    }
}

