/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.impl;

import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.DnsDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.core.Atomix;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.protocols.raft.partition.RaftPartitionGroup;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=false, service={AtomixManager.class})
public class AtomixManager {
    private static final String LOCAL_DATA_DIR = System.getProperty("karaf.data") + "/db/partitions/";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected ClusterMetadataService metadataService;
    private Atomix atomix;

    public Atomix getAtomix() {
        return this.atomix;
    }

    @Activate
    public void activate() {
        this.log.info("{}", (Object)this.metadataService.getClusterMetadata());
        this.atomix = this.createAtomix();
        this.atomix.start().join();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.atomix.stop().join();
        this.log.info("Stopped");
    }

    private Atomix createAtomix() {
        ClusterMetadata metadata = this.metadataService.getClusterMetadata();
        NodeDiscoveryProvider discovery = metadata.getStorageDnsService() != null ? DnsDiscoveryProvider.builder().withService(metadata.getStorageDnsService()).build() : BootstrapDiscoveryProvider.builder().withNodes((Collection)metadata.getStorageNodes().stream().map(node -> Node.builder().withId((String)node.id().id()).withHost(node.host()).withPort(node.tcpPort()).build()).collect(Collectors.toList())).build();
        if (!metadata.getStorageNodes().isEmpty()) {
            return Atomix.builder((ClassLoader)this.getClass().getClassLoader()).withClusterId(metadata.getName()).withMemberId((String)this.metadataService.getLocalNode().id().id()).withHost(metadata.getLocalNode().host()).withPort(metadata.getLocalNode().tcpPort()).withProperty("type", "onos").withMembershipProvider(discovery).build();
        }
        this.log.warn("No storage nodes found in cluster metadata!");
        this.log.warn("Bootstrapping ONOS cluster in test mode! For production use, configure external storage nodes.");
        List<String> raftMembers = !metadata.getControllerNodes().isEmpty() ? metadata.getControllerNodes().stream().map(node -> (String)node.id().id()).collect(Collectors.toList()) : Collections.singletonList((String)this.metadataService.getLocalNode().id().id());
        return Atomix.builder((ClassLoader)this.getClass().getClassLoader()).withClusterId(metadata.getName()).withMemberId((String)this.metadataService.getLocalNode().id().id()).withHost(metadata.getLocalNode().host()).withPort(metadata.getLocalNode().tcpPort()).withProperty("type", "onos").withMembershipProvider(discovery).withManagementGroup((ManagedPartitionGroup)RaftPartitionGroup.builder((String)"system").withNumPartitions(1).withDataDirectory(new File(LOCAL_DATA_DIR, "system")).withMembers(raftMembers).build()).addPartitionGroup((ManagedPartitionGroup)RaftPartitionGroup.builder((String)"raft").withNumPartitions(raftMembers.size()).withDataDirectory(new File(LOCAL_DATA_DIR, "data")).withMembers(raftMembers).build()).build();
    }
}

