/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.core.workqueue.AsyncWorkQueue;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.Task;
import org.onosproject.store.service.WorkQueue;
import org.onosproject.store.service.WorkQueueStats;

public class AtomixWorkQueue<E>
implements WorkQueue<E> {
    private final AsyncWorkQueue<E> atomixWorkQueue;

    public AtomixWorkQueue(AsyncWorkQueue<E> atomixWorkQueue) {
        this.atomixWorkQueue = atomixWorkQueue;
    }

    public String name() {
        return this.atomixWorkQueue.name();
    }

    public CompletableFuture<Void> addMultiple(Collection<E> items) {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.addMultiple(items));
    }

    public CompletableFuture<Collection<Task<E>>> take(int maxItems) {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.take(maxItems)).thenApply(tasks -> tasks.stream().map(task -> new Task(task.taskId(), task.payload())).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> complete(Collection<String> taskIds) {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.complete(taskIds));
    }

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> taskProcessor, int parallelism, Executor executor) {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.registerTaskProcessor(taskProcessor, parallelism, executor));
    }

    public CompletableFuture<Void> stopProcessing() {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.stopProcessing());
    }

    public CompletableFuture<WorkQueueStats> stats() {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.stats()).thenApply(stats -> WorkQueueStats.builder().withTotalCompleted(stats.totalCompleted()).withTotalInProgress(stats.totalInProgress()).withTotalPending(stats.totalPending()).build());
    }

    public CompletableFuture<Void> destroy() {
        return AtomixFutures.adaptFuture(this.atomixWorkQueue.delete());
    }
}

