/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.impl.TranscodingAsyncDistributedCollection;
import io.atomix.core.map.AsyncAtomicNavigableMap;
import io.atomix.core.map.AtomicMapEvent;
import io.atomix.core.map.AtomicMapEventListener;
import io.atomix.core.map.impl.DelegatingAsyncDistributedNavigableMap;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.primitives.MapUpdate;
import org.onosproject.store.primitives.TransactionId;
import org.onosproject.store.service.AsyncConsistentTreeMap;
import org.onosproject.store.service.AsyncIterator;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.TransactionLog;
import org.onosproject.store.service.Version;

public class AtomixConsistentTreeMap<V>
implements AsyncConsistentTreeMap<V> {
    private final AsyncAtomicNavigableMap<String, V> atomixTreeMap;
    private final Map<MapEventListener<String, V>, AtomicMapEventListener<String, V>> listenerMap = Maps.newIdentityHashMap();

    public AtomixConsistentTreeMap(AsyncAtomicNavigableMap<String, V> atomixTreeMap) {
        this.atomixTreeMap = atomixTreeMap;
    }

    public String name() {
        return this.atomixTreeMap.name();
    }

    public CompletableFuture<Integer> size() {
        return this.atomixTreeMap.size();
    }

    public CompletableFuture<String> firstKey() {
        return this.atomixTreeMap.firstKey();
    }

    public CompletableFuture<String> lastKey() {
        return this.atomixTreeMap.lastKey();
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> ceilingEntry(String key) {
        return this.atomixTreeMap.ceilingEntry((Comparable)((Object)key)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> floorEntry(String key) {
        return this.atomixTreeMap.floorEntry((Comparable)((Object)key)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> higherEntry(String key) {
        return this.atomixTreeMap.higherEntry((Comparable)((Object)key)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> lowerEntry(String key) {
        return this.atomixTreeMap.lowerEntry((Comparable)((Object)key)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> firstEntry() {
        return this.atomixTreeMap.firstEntry().thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> lastEntry() {
        return this.atomixTreeMap.lastEntry().thenApply(this::toVersioned);
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> containsKey(String key) {
        return this.atomixTreeMap.containsKey((Object)key);
    }

    public CompletableFuture<String> lowerKey(String key) {
        return this.atomixTreeMap.lowerKey((Comparable)((Object)key));
    }

    public CompletableFuture<String> floorKey(String key) {
        return this.atomixTreeMap.floorKey((Comparable)((Object)key));
    }

    public CompletableFuture<String> ceilingKey(String key) {
        return this.atomixTreeMap.ceilingKey((Comparable)((Object)key));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> get(String key) {
        return this.atomixTreeMap.get((Object)key).thenApply(this::toVersioned);
    }

    public CompletableFuture<String> higherKey(String key) {
        return this.atomixTreeMap.higherKey((Comparable)((Object)key));
    }

    public CompletableFuture<NavigableSet<String>> navigableKeySet() {
        return CompletableFuture.completedFuture(this.atomixTreeMap.navigableKeySet().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> getOrDefault(String key, V defaultValue) {
        return this.atomixTreeMap.getOrDefault((Object)key, defaultValue).thenApply(this::toVersioned);
    }

    public CompletableFuture<NavigableMap<String, V>> subMap(String upperKey, String lowerKey, boolean inclusiveUpper, boolean inclusiveLower) {
        return CompletableFuture.completedFuture(new DelegatingAsyncDistributedNavigableMap(this.atomixTreeMap.subMap((Comparable)((Object)lowerKey), inclusiveLower, (Comparable)((Object)upperKey), inclusiveUpper)).sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> computeIf(String key, Predicate<? super V> condition, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.computeIf((Object)key, condition, remappingFunction)).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> put(String key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.put((Object)key, value)).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> putAndGet(String key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.putAndGet((Object)key, value)).thenApply(this::toVersioned);
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> remove(String key) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.remove((Object)key)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Set<String>> keySet() {
        return CompletableFuture.completedFuture(this.atomixTreeMap.keySet().sync(Duration.ofMillis(15000L)));
    }

    public CompletableFuture<Set<Map.Entry<String, org.onosproject.store.service.Versioned<V>>>> entrySet() {
        return CompletableFuture.completedFuture(this.atomixTreeMap.entrySet().stream().map(this::toVersioned).collect(Collectors.toSet()));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> putIfAbsent(String key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.putIfAbsent((Object)key, value)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Boolean> remove(String key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.remove((Object)key, value));
    }

    public CompletableFuture<Boolean> remove(String key, long version) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.remove((Object)key, version));
    }

    public CompletableFuture<org.onosproject.store.service.Versioned<V>> replace(String key, V value) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.replace((Object)key, value)).thenApply(this::toVersioned);
    }

    public CompletableFuture<Boolean> replace(String key, V oldValue, V newValue) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.replace((Object)key, oldValue, newValue));
    }

    public CompletableFuture<Boolean> replace(String key, long oldVersion, V newValue) {
        return AtomixFutures.adaptMapFuture(this.atomixTreeMap.replace((Object)key, oldVersion, newValue));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        return this.atomixTreeMap.containsValue(value);
    }

    public CompletableFuture<AsyncIterator<Map.Entry<String, org.onosproject.store.service.Versioned<V>>>> iterator() {
        final io.atomix.core.iterator.AsyncIterator atomixIterator = this.atomixTreeMap.entrySet().iterator();
        return CompletableFuture.completedFuture(new AsyncIterator<Map.Entry<String, org.onosproject.store.service.Versioned<V>>>(){

            public CompletableFuture<Boolean> hasNext() {
                return atomixIterator.hasNext();
            }

            public CompletableFuture<Map.Entry<String, org.onosproject.store.service.Versioned<V>>> next() {
                return atomixIterator.next().thenApply(entry -> Maps.immutableEntry((Object)((String)entry.getKey()), AtomixConsistentTreeMap.this.toVersioned((Versioned)entry.getValue())));
            }
        });
    }

    public CompletableFuture<Void> clear() {
        return this.atomixTreeMap.clear();
    }

    public CompletableFuture<Collection<org.onosproject.store.service.Versioned<V>>> values() {
        return CompletableFuture.completedFuture(new TranscodingAsyncDistributedCollection(this.atomixTreeMap.values(), e -> new Versioned(e.value(), e.version()), e -> new org.onosproject.store.service.Versioned(e.value(), e.version())).sync(Duration.ofMillis(15000L)));
    }

    public synchronized CompletableFuture<Void> addListener(MapEventListener<String, V> listener, Executor executor) {
        AtomicMapEventListener atomixListener = event -> listener.event(new MapEvent(MapEvent.Type.valueOf((String)((AtomicMapEvent.Type)event.type()).name()), this.name(), (Object)((String)event.key()), this.toVersioned(event.newValue()), this.toVersioned(event.oldValue())));
        this.listenerMap.put(listener, atomixListener);
        return this.atomixTreeMap.addListener(atomixListener, executor);
    }

    public CompletableFuture<Void> removeListener(MapEventListener<String, V> listener) {
        AtomicMapEventListener<String, V> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return this.atomixTreeMap.removeListener(atomixListener);
        }
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Version> begin(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepare(TransactionLog<MapUpdate<String, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Boolean> prepareAndCommit(TransactionLog<MapUpdate<String, V>> transactionLog) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> commit(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> rollback(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    private org.onosproject.store.service.Versioned<V> toVersioned(Versioned<V> versioned) {
        return versioned != null ? new org.onosproject.store.service.Versioned(versioned.value(), versioned.version(), versioned.creationTime()) : null;
    }

    private Map.Entry<String, org.onosproject.store.service.Versioned<V>> toVersioned(Map.Entry<String, Versioned<V>> entry) {
        return entry != null ? Maps.immutableEntry((Object)entry.getKey(), this.toVersioned(entry.getValue())) : null;
    }
}

