/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import com.google.common.collect.Maps;
import io.atomix.core.collection.CollectionEvent;
import io.atomix.core.collection.CollectionEventListener;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.SetEvent;
import org.onosproject.store.service.SetEventListener;

public class AtomixDistributedSet<E>
implements AsyncDistributedSet<E> {
    private final io.atomix.core.set.AsyncDistributedSet<E> atomixSet;
    private final Map<SetEventListener<E>, CollectionEventListener<E>> listenerMap = Maps.newIdentityHashMap();

    public AtomixDistributedSet(io.atomix.core.set.AsyncDistributedSet<E> atomixSet) {
        this.atomixSet = atomixSet;
    }

    public String name() {
        return this.atomixSet.name();
    }

    public CompletableFuture<Integer> size() {
        return AtomixFutures.adaptFuture(this.atomixSet.size());
    }

    public CompletableFuture<Boolean> add(E element) {
        return AtomixFutures.adaptFuture(this.atomixSet.add(element));
    }

    public CompletableFuture<Boolean> remove(E element) {
        return AtomixFutures.adaptFuture(this.atomixSet.remove(element));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return AtomixFutures.adaptFuture(this.atomixSet.isEmpty());
    }

    public CompletableFuture<Void> clear() {
        return AtomixFutures.adaptFuture(this.atomixSet.clear());
    }

    public CompletableFuture<Boolean> contains(E element) {
        return AtomixFutures.adaptFuture(this.atomixSet.contains(element));
    }

    public CompletableFuture<Boolean> addAll(Collection<? extends E> c) {
        return AtomixFutures.adaptFuture(this.atomixSet.addAll(c));
    }

    public CompletableFuture<Boolean> containsAll(Collection<? extends E> c) {
        return AtomixFutures.adaptFuture(this.atomixSet.containsAll(c));
    }

    public CompletableFuture<Boolean> retainAll(Collection<? extends E> c) {
        return AtomixFutures.adaptFuture(this.atomixSet.retainAll(c));
    }

    public CompletableFuture<Boolean> removeAll(Collection<? extends E> c) {
        return AtomixFutures.adaptFuture(this.atomixSet.removeAll(c));
    }

    public CompletableFuture<? extends Set<E>> getAsImmutableSet() {
        return CompletableFuture.completedFuture(this.atomixSet.stream().collect(Collectors.toSet()));
    }

    public synchronized CompletableFuture<Void> addListener(SetEventListener<E> listener) {
        CollectionEventListener atomixListener = event -> listener.event(new SetEvent(this.name(), SetEvent.Type.valueOf((String)((CollectionEvent.Type)event.type()).name()), event.element()));
        this.listenerMap.put(listener, atomixListener);
        return AtomixFutures.adaptFuture(this.atomixSet.addListener(atomixListener));
    }

    public CompletableFuture<Void> removeListener(SetEventListener<E> listener) {
        CollectionEventListener<E> atomixListener = this.listenerMap.remove(listener);
        if (atomixListener != null) {
            return AtomixFutures.adaptFuture(this.atomixSet.removeListener(atomixListener));
        }
        return CompletableFuture.completedFuture(null);
    }
}

