/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.atomix.primitives.impl;

import io.atomix.core.lock.AsyncAtomicLock;
import io.atomix.utils.time.Version;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.atomix.primitives.impl.AtomixFutures;
import org.onosproject.store.service.AsyncDistributedLock;

public class AtomixDistributedLock
implements AsyncDistributedLock {
    private final AsyncAtomicLock atomixLock;

    public AtomixDistributedLock(AsyncAtomicLock atomixLock) {
        this.atomixLock = atomixLock;
    }

    public String name() {
        return this.atomixLock.name();
    }

    public CompletableFuture<org.onosproject.store.service.Version> lock() {
        return AtomixFutures.adaptFuture(this.atomixLock.lock()).thenApply(this::toVersion);
    }

    public CompletableFuture<Optional<org.onosproject.store.service.Version>> tryLock() {
        return AtomixFutures.adaptFuture(this.atomixLock.tryLock()).thenApply(optional -> optional.map(this::toVersion));
    }

    public CompletableFuture<Optional<org.onosproject.store.service.Version>> tryLock(Duration timeout) {
        return AtomixFutures.adaptFuture(this.atomixLock.tryLock(timeout)).thenApply(optional -> optional.map(this::toVersion));
    }

    public CompletableFuture<Void> unlock() {
        return AtomixFutures.adaptFuture(this.atomixLock.unlock());
    }

    private org.onosproject.store.service.Version toVersion(Version version) {
        return new org.onosproject.store.service.Version(version.value());
    }
}

