/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public final class IpPrefixSerializer
extends Serializer<IpPrefix> {
    public IpPrefixSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, IpPrefix object) {
        byte[] octs = object.address().toOctets();
        output.writeInt(octs.length);
        output.writeBytes(octs);
        output.writeInt(object.prefixLength());
    }

    public IpPrefix read(Kryo kryo, Input input, Class<IpPrefix> type) {
        int octLen = input.readInt();
        byte[] octs = new byte[octLen];
        input.readBytes(octs);
        int prefLen = input.readInt();
        if (octLen == 4) {
            return IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])octs, (int)prefLen);
        }
        if (octLen == 16) {
            return IpPrefix.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])octs, (int)prefLen);
        }
        return null;
    }
}

