/*
 * Copyright 2014 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableList.Builder;

/**
 * Creates {@link ImmutableList} serializer instance.
 */
public class ImmutableListSerializer extends Serializer<ImmutableList<?>> {

    /**
     * Creates {@link ImmutableList} serializer instance.
     */
    public ImmutableListSerializer() {
        // non-null, immutable
        super(false, true);
    }
    @Override
    public void write(Kryo kryo, Output output, ImmutableList<?> object) {
        output.writeInt(object.size());
        for (Object e : object) {
            kryo.writeClassAndObject(output, e);
        }
    }

    @Override
    public ImmutableList<?> read(Kryo kryo, Input input,
            Class<ImmutableList<?>> type) {
        final int size = input.readInt();
        Builder<Object> builder = ImmutableList.builder();
        for (int i = 0; i < size; ++i) {
            builder.add(kryo.readClassAndObject(input));
        }
        return builder.build();
    }
}
