/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onlab.packet.IpAddress;

public class IpAddressSerializer
extends Serializer<IpAddress> {
    public IpAddressSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, IpAddress object) {
        byte[] octs = object.toOctets();
        output.writeInt(octs.length);
        output.writeBytes(octs);
    }

    public IpAddress read(Kryo kryo, Input input, Class<IpAddress> type) {
        int octLen = input.readInt();
        byte[] octs = new byte[octLen];
        input.readBytes(octs);
        if (octLen == 4) {
            return IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])octs);
        }
        if (octLen == 16) {
            return IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])octs);
        }
        return null;
    }
}

