/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.testing.EqualsTester;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.Ip6Prefix;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onlab.util.Frequency;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.Annotations;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPort;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.ElementId;
import org.onosproject.net.GridType;
import org.onosproject.net.HostLocation;
import org.onosproject.net.IndexedLambda;
import org.onosproject.net.Lambda;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.OchPort;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduCltPort;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.OmsPort;
import org.onosproject.net.OtuPort;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.constraint.AnnotationConstraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LambdaConstraint;
import org.onosproject.net.intent.constraint.LatencyConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;
import org.onosproject.net.intent.constraint.ObstacleConstraint;
import org.onosproject.net.intent.constraint.WaypointConstraint;
import org.onosproject.net.newresource.Resource;
import org.onosproject.net.newresource.ResourceAllocation;
import org.onosproject.net.newresource.ResourceConsumer;
import org.onosproject.net.newresource.Resources;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceAllocation;
import org.onosproject.net.resource.link.DefaultLinkResourceAllocations;
import org.onosproject.net.resource.link.DefaultLinkResourceRequest;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LambdaResourceAllocation;
import org.onosproject.net.resource.link.LinkResourceRequest;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;

public class KryoSerializerTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final ProviderId PIDA = new ProviderId("of", "foo", true);
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final ConnectPoint CP1 = new ConnectPoint((ElementId)DID1, P1);
    private static final ConnectPoint CP2 = new ConnectPoint((ElementId)DID2, P2);
    private static final String MFR = "whitebox";
    private static final String HW = "1.1.x";
    private static final String SW1 = "3.8.1";
    private static final String SW2 = "3.9.5";
    private static final String SN = "43311-12345";
    private static final ChassisId CID = new ChassisId();
    private static final Device DEV1 = new DefaultDevice(PID, DID1, Device.Type.SWITCH, "whitebox", "1.1.x", "3.8.1", "43311-12345", CID, new Annotations[0]);
    private static final SparseAnnotations A1 = DefaultAnnotations.builder().set("A1", "a1").set("B1", "b1").build();
    private static final SparseAnnotations A1_2 = DefaultAnnotations.builder().remove("A1").set("B3", "b3").build();
    private static final OchSignal OCH_SIGNAL1 = (OchSignal)Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)-8, (int)4);
    private static final VlanId VLAN1 = VlanId.vlanId((short)100);
    private KryoSerializer serializer;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.serializer = new KryoSerializer(){

            protected void setupKryoPool() {
                this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(300).build();
            }
        };
    }

    @After
    public void tearDown() throws Exception {
    }

    private <T> void testSerializedEquals(T original) {
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        this.serializer.encode(original, buffer);
        buffer.flip();
        Object copy = this.serializer.decode(buffer);
        Object copy2 = this.serializer.decode(this.serializer.encode(original));
        new EqualsTester().addEqualityGroup(new Object[]{original, copy, copy2}).testEquals();
    }

    private <T> void testSerializable(T original) {
        byte[] bs = this.serializer.encode(original);
        Object copy = this.serializer.decode(bs);
        Assert.assertNotNull((Object)copy);
    }

    @Test
    public void testConnectPoint() {
        this.testSerializedEquals(new ConnectPoint((ElementId)DID1, P1));
    }

    @Test
    public void testDefaultLink() {
        this.testSerializedEquals(DefaultLink.builder().providerId(PID).src(CP1).dst(CP2).type(Link.Type.DIRECT).build());
        this.testSerializedEquals(DefaultLink.builder().providerId(PID).src(CP1).dst(CP2).type(Link.Type.DIRECT).annotations((Annotations)A1).build());
    }

    @Test
    public void testDefaultPort() {
        this.testSerializedEquals(new DefaultPort((Element)DEV1, P1, true, new Annotations[0]));
        this.testSerializedEquals(new DefaultPort((Element)DEV1, P1, true, new Annotations[]{A1_2}));
    }

    @Test
    public void testOmsPort() {
        this.testSerializedEquals(new OmsPort((Element)DEV1, P1, true, Frequency.ofGHz((long)190100L), Frequency.ofGHz((long)197300L), Frequency.ofGHz((long)100L), new Annotations[0]));
        this.testSerializedEquals(new OmsPort((Element)DEV1, P1, true, Frequency.ofGHz((long)190100L), Frequency.ofGHz((long)197300L), Frequency.ofGHz((long)100L), new Annotations[]{A1_2}));
    }

    @Test
    public void testOchPort() {
        this.testSerializedEquals(new OchPort((Element)DEV1, P1, true, OduSignalType.ODU0, false, OCH_SIGNAL1, new Annotations[0]));
        this.testSerializedEquals(new OchPort((Element)DEV1, P1, true, OduSignalType.ODU0, false, OCH_SIGNAL1, new Annotations[]{A1_2}));
    }

    @Test
    public void testOduCltPort() {
        this.testSerializedEquals(new OduCltPort((Element)DEV1, P1, true, CltSignalType.CLT_10GBE, new Annotations[0]));
        this.testSerializedEquals(new OduCltPort((Element)DEV1, P1, true, CltSignalType.CLT_10GBE, new Annotations[]{A1_2}));
    }

    @Test
    public void testOtuPort() {
        this.testSerializedEquals(new OtuPort((Element)DEV1, P1, true, OtuSignalType.OTU2, new Annotations[0]));
        this.testSerializedEquals(new OtuPort((Element)DEV1, P1, true, OtuSignalType.OTU2, new Annotations[]{A1_2}));
    }

    @Test
    public void testDeviceId() {
        this.testSerializedEquals(DID1);
    }

    @Test
    public void testImmutableMap() {
        this.testSerializedEquals(ImmutableMap.of((Object)DID1, (Object)DEV1, (Object)DID2, (Object)DEV1));
        this.testSerializedEquals(ImmutableMap.of((Object)DID1, (Object)DEV1));
        this.testSerializedEquals(ImmutableMap.of());
    }

    @Test
    public void testImmutableSet() {
        this.testSerializedEquals(ImmutableSet.of((Object)DID1, (Object)DID2));
        this.testSerializedEquals(ImmutableSet.of((Object)DID1));
        this.testSerializedEquals(ImmutableSet.of());
    }

    @Test
    public void testImmutableList() {
        this.testSerializedEquals(ImmutableList.of((Object)DID1, (Object)DID2));
        this.testSerializedEquals(ImmutableList.of((Object)DID1));
        this.testSerializedEquals(ImmutableList.of());
    }

    @Test
    public void testFlowRuleBatchEntry() {
        FlowRule rule1 = DefaultFlowRule.builder().forDevice(DID1).withSelector(DefaultTrafficSelector.emptySelector()).withTreatment(DefaultTrafficTreatment.emptyTreatment()).withPriority(0).fromApp((ApplicationId)new DefaultApplicationId(1, "1")).makeTemporary(1).build();
        FlowRuleBatchEntry entry1 = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, rule1);
        FlowRuleBatchEntry entry2 = new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, rule1, Long.valueOf(100L));
        this.testSerializedEquals(entry1);
        this.testSerializedEquals(entry2);
    }

    @Test
    public void testIpPrefix() {
        this.testSerializedEquals(IpPrefix.valueOf((String)"192.168.0.1/24"));
    }

    @Test
    public void testIp4Prefix() {
        this.testSerializedEquals(Ip4Prefix.valueOf((String)"192.168.0.1/24"));
    }

    @Test
    public void testIp6Prefix() {
        this.testSerializedEquals(Ip6Prefix.valueOf((String)"1111:2222::/120"));
    }

    @Test
    public void testIpAddress() {
        this.testSerializedEquals(IpAddress.valueOf((String)"192.168.0.1"));
    }

    @Test
    public void testIp4Address() {
        this.testSerializedEquals(Ip4Address.valueOf((String)"192.168.0.1"));
    }

    @Test
    public void testIp6Address() {
        this.testSerializedEquals(Ip6Address.valueOf((String)"1111:2222::"));
    }

    @Test
    public void testMacAddress() {
        this.testSerializedEquals(MacAddress.valueOf((String)"12:34:56:78:90:ab"));
    }

    @Test
    public void testLinkKey() {
        this.testSerializedEquals(LinkKey.linkKey((ConnectPoint)CP1, (ConnectPoint)CP2));
    }

    @Test
    public void testNodeId() {
        this.testSerializedEquals(new NodeId("SomeNodeIdentifier"));
    }

    @Test
    public void testPortNumber() {
        this.testSerializedEquals(P1);
    }

    @Test
    public void testProviderId() {
        this.testSerializedEquals(PID);
        this.testSerializedEquals(PIDA);
    }

    @Test
    public void testMastershipTerm() {
        this.testSerializedEquals(MastershipTerm.of((NodeId)new NodeId("foo"), (long)2L));
        this.testSerializedEquals(MastershipTerm.of(null, (long)0L));
    }

    @Test
    public void testHostLocation() {
        this.testSerializedEquals(new HostLocation(CP1, 1234L));
    }

    @Test
    public void testFlowId() {
        this.testSerializedEquals(FlowId.valueOf((long)305419896L));
    }

    @Test
    public void testRoleInfo() {
        this.testSerializedEquals(new RoleInfo(new NodeId("master"), Arrays.asList(new NodeId("stby1"), new NodeId("stby2"))));
    }

    @Test
    public void testIndexedLambda() {
        this.testSerializedEquals(Lambda.indexedLambda((long)10L));
    }

    @Test
    public void testOchSignal() {
        this.testSerializedEquals(Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)1, (int)1));
    }

    @Test
    public void testDefaultLinkResourceRequest() {
        this.testSerializable(DefaultLinkResourceRequest.builder((IntentId)IntentId.valueOf((long)2501L), (Collection)ImmutableList.of()).addLambdaRequest().addBandwidthRequest(32.195).build());
    }

    @Test
    public void testDefaultLinkResourceAllocations() {
        LinkResourceRequest request = DefaultLinkResourceRequest.builder((IntentId)IntentId.valueOf((long)2501L), (Collection)ImmutableList.of()).addLambdaRequest().addBandwidthRequest(32.195).build();
        HashMap<DefaultLink, ImmutableSet> allocations = new HashMap<DefaultLink, ImmutableSet>();
        allocations.put(DefaultLink.builder().providerId(PID).src(CP1).dst(CP2).type(Link.Type.DIRECT).build(), ImmutableSet.of((Object)new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)10.0))), (Object)new LambdaResourceAllocation(LambdaResource.valueOf((int)1))));
        this.testSerializable(new DefaultLinkResourceAllocations(request, allocations));
    }

    @Test
    public void testResource() {
        this.testSerializedEquals(Resources.discrete((DeviceId)DID1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource());
    }

    @Test
    public void testResourceId() {
        this.testSerializedEquals(Resources.discrete((DeviceId)DID1, (PortNumber)P1, (Object[])new Object[0]).id());
    }

    @Test
    public void testResourceAllocation() {
        this.testSerializedEquals(new ResourceAllocation((Resource)Resources.discrete((DeviceId)DID1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource(), (ResourceConsumer)IntentId.valueOf((long)30L)));
    }

    @Test
    public void testFrequency() {
        this.testSerializedEquals(Frequency.ofGHz((long)100L));
    }

    @Test
    public void testBandwidth() {
        this.testSerializedEquals(Bandwidth.mbps((long)1000L));
        this.testSerializedEquals(Bandwidth.mbps((double)1000.0));
    }

    @Test
    public void testLambdaConstraint() {
        this.testSerializable(new LambdaConstraint(new IndexedLambda(1L)));
    }

    @Test
    public void testBandwidthConstraint() {
        this.testSerializable(new BandwidthConstraint(Bandwidth.bps((double)1000.0)));
    }

    @Test
    public void testLinkTypeConstraint() {
        this.testSerializable(new LinkTypeConstraint(true, new Link.Type[]{Link.Type.DIRECT}));
    }

    @Test
    public void testLatencyConstraint() {
        this.testSerializable(new LatencyConstraint(Duration.ofSeconds(10L)));
    }

    @Test
    public void testWaypointConstraint() {
        this.testSerializable(new WaypointConstraint(new DeviceId[]{DeviceId.deviceId((String)"of:1"), DeviceId.deviceId((String)"of:2")}));
    }

    @Test
    public void testObstacleConstraint() {
        this.testSerializable(new ObstacleConstraint(new DeviceId[]{DeviceId.deviceId((String)"of:1"), DeviceId.deviceId((String)"of:2")}));
    }

    @Test
    public void testArraysAsList() {
        this.testSerializedEquals(Arrays.asList(1, 2, 3));
    }

    @Test
    public void testAnnotationConstraint() {
        this.testSerializable(new AnnotationConstraint("distance", 100.0));
    }

    @Test
    public void testDefaultGroupId() {
        this.testSerializedEquals(new DefaultGroupId(99));
    }

    @Test
    public void testEmptySet() {
        this.testSerializedEquals(Collections.emptySet());
    }

    @Test
    public void testAnnotations() {
        byte[] a1Bytes = this.serializer.encode((Object)A1);
        SparseAnnotations copiedA1 = (SparseAnnotations)this.serializer.decode(a1Bytes);
        KryoSerializerTest.assertAnnotationsEquals((Annotations)copiedA1, A1);
        byte[] a12Bytes = this.serializer.encode((Object)A1_2);
        SparseAnnotations copiedA12 = (SparseAnnotations)this.serializer.decode(a12Bytes);
        KryoSerializerTest.assertAnnotationsEquals((Annotations)copiedA12, A1_2);
    }

    protected static void assertAnnotationsEquals(Annotations actual, SparseAnnotations ... annotations) {
        DefaultAnnotations expected = DefaultAnnotations.builder().build();
        for (SparseAnnotations a : annotations) {
            expected = DefaultAnnotations.union((SparseAnnotations)expected, (SparseAnnotations)a);
        }
        Assert.assertEquals((Object)expected.keys(), (Object)actual.keys());
        for (String key : expected.keys()) {
            Assert.assertEquals((Object)expected.value(key), (Object)actual.value(key));
        }
    }
}

