/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.DefaultDriverHandler;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.DriverData;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.UnresolvedExtensionTreatment;

public class ExtensionInstructionSerializer
extends Serializer<Instructions.ExtensionInstructionWrapper> {
    public ExtensionInstructionSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, Instructions.ExtensionInstructionWrapper object) {
        kryo.writeClassAndObject(output, (Object)object.extensionInstruction().type());
        kryo.writeClassAndObject(output, (Object)object.deviceId());
        DriverService driverService = (DriverService)DefaultServiceDirectory.getService(DriverService.class);
        Driver driver = driverService.getDriver(object.deviceId());
        kryo.writeClassAndObject(output, (Object)driver.name());
        kryo.writeClassAndObject(output, (Object)object.extensionInstruction().serialize());
    }

    public Instructions.ExtensionInstructionWrapper read(Kryo kryo, Input input, Class<Instructions.ExtensionInstructionWrapper> type) {
        UnresolvedExtensionTreatment instruction;
        ExtensionTreatmentType exType = (ExtensionTreatmentType)kryo.readClassAndObject(input);
        DeviceId deviceId = (DeviceId)kryo.readClassAndObject(input);
        String driverName = (String)kryo.readClassAndObject(input);
        DriverService driverService = (DriverService)DefaultServiceDirectory.getService(DriverService.class);
        byte[] bytes = (byte[])kryo.readClassAndObject(input);
        try {
            DefaultDriverHandler handler = new DefaultDriverHandler((DriverData)new DefaultDriverData(driverService.getDriver(driverName), deviceId));
            ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
            instruction = resolver.getExtensionInstruction(exType);
            instruction.deserialize(bytes);
        }
        catch (IllegalArgumentException | ItemNotFoundException e) {
            instruction = new UnresolvedExtensionTreatment(bytes, exType);
        }
        return Instructions.extension((ExtensionTreatment)instruction, (DeviceId)deviceId);
    }
}

