/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableList;

public class ImmutableListSerializer
extends Serializer<ImmutableList<?>> {
    public ImmutableListSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, ImmutableList<?> object) {
        output.writeInt(object.size());
        for (Object e : object) {
            kryo.writeClassAndObject(output, e);
        }
    }

    public ImmutableList<?> read(Kryo kryo, Input input, Class<ImmutableList<?>> type) {
        int size = input.readInt();
        switch (size) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of((Object)kryo.readClassAndObject(input));
            }
        }
        Object[] elms = new Object[size];
        for (int i = 0; i < size; ++i) {
            elms[i] = kryo.readClassAndObject(input);
        }
        return ImmutableList.copyOf((Object[])elms);
    }
}

