/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onlab.util.ImmutableByteSequence;

public class ImmutableByteSequenceSerializer
extends Serializer<ImmutableByteSequence> {
    public ImmutableByteSequenceSerializer() {
        super(false, true);
    }

    public void write(Kryo kryo, Output output, ImmutableByteSequence object) {
        byte[] data = object.asArray();
        output.writeBoolean(object.isAscii());
        output.writeInt(data.length);
        output.write(data);
    }

    public ImmutableByteSequence read(Kryo kryo, Input input, Class<ImmutableByteSequence> type) {
        boolean isAscii = input.readBoolean();
        int length = input.readInt();
        byte[] data = new byte[length];
        int bytesRead = input.read(data);
        if (bytesRead != length) {
            throw new IllegalStateException("Byte sequence serializer read expected " + length + " but got " + bytesRead);
        }
        if (isAscii) {
            return ImmutableByteSequence.copyFrom((String)new String(data));
        }
        return ImmutableByteSequence.copyFrom((byte[])data);
    }
}

