/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.DefaultGraphDescription;
import org.onosproject.net.topology.GraphDescription;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.trivial.impl.DefaultTopology;

public class DefaultTopologyTest {
    public static final ProviderId PID = new ProviderId("of", "foo.bar");
    public static final DeviceId D1 = DeviceId.deviceId((String)"of:1");
    public static final DeviceId D2 = DeviceId.deviceId((String)"of:2");
    public static final DeviceId D3 = DeviceId.deviceId((String)"of:3");
    public static final DeviceId D4 = DeviceId.deviceId((String)"of:4");
    public static final DeviceId D5 = DeviceId.deviceId((String)"of:5");
    public static final PortNumber P1 = PortNumber.portNumber((long)1L);
    public static final PortNumber P2 = PortNumber.portNumber((long)2L);
    public static final LinkWeight WEIGHT = edge -> ((TopologyVertex)edge.src()).deviceId().equals((Object)D4) || ((TopologyVertex)edge.dst()).deviceId().equals((Object)D4) ? 2.0 : 1.0;
    private DefaultTopology dt;

    @Before
    public void setUp() {
        long now = System.currentTimeMillis();
        ImmutableSet devices = ImmutableSet.of((Object)DefaultTopologyTest.device("1"), (Object)DefaultTopologyTest.device("2"), (Object)DefaultTopologyTest.device("3"), (Object)DefaultTopologyTest.device("4"), (Object)DefaultTopologyTest.device("5"));
        ImmutableSet links = ImmutableSet.of((Object)DefaultTopologyTest.link("1", 1, "2", 1), (Object)DefaultTopologyTest.link("2", 1, "1", 1), (Object)DefaultTopologyTest.link("3", 2, "2", 2), (Object)DefaultTopologyTest.link("2", 2, "3", 2), (Object)DefaultTopologyTest.link("1", 3, "4", 3), (Object)DefaultTopologyTest.link("4", 3, "1", 3), (Object[])new Link[]{DefaultTopologyTest.link("3", 4, "4", 4), DefaultTopologyTest.link("4", 4, "3", 4)});
        DefaultGraphDescription graphDescription = new DefaultGraphDescription(now, (Iterable)devices, (Iterable)links, new SparseAnnotations[0]);
        this.dt = new DefaultTopology(PID, (GraphDescription)graphDescription);
        Assert.assertEquals((String)"incorrect supplier", (Object)PID, (Object)this.dt.providerId());
        Assert.assertEquals((String)"incorrect time", (long)now, (long)this.dt.time());
        Assert.assertEquals((String)"incorrect device count", (long)5L, (long)this.dt.deviceCount());
        Assert.assertEquals((String)"incorrect link count", (long)8L, (long)this.dt.linkCount());
        Assert.assertEquals((String)"incorrect cluster count", (long)2L, (long)this.dt.clusterCount());
        Assert.assertEquals((String)"incorrect broadcast set size", (long)6L, (long)this.dt.broadcastSetSize(ClusterId.clusterId((int)0)));
    }

    @Test
    public void pathRelated() {
        Set paths = this.dt.getPaths(D1, D2);
        Assert.assertEquals((String)"incorrect path count", (long)1L, (long)paths.size());
        paths = this.dt.getPaths(D1, D3);
        Assert.assertEquals((String)"incorrect path count", (long)2L, (long)paths.size());
        paths = this.dt.getPaths(D1, D5);
        Assert.assertTrue((String)"no paths expected", (boolean)paths.isEmpty());
        paths = this.dt.getPaths(D1, D3, WEIGHT);
        Assert.assertEquals((String)"incorrect path count", (long)1L, (long)paths.size());
    }

    @Test
    public void pointRelated() {
        Assert.assertTrue((String)"should be infrastructure point", (boolean)this.dt.isInfrastructure(new ConnectPoint((ElementId)D1, P1)));
        Assert.assertFalse((String)"should not be infrastructure point", (boolean)this.dt.isInfrastructure(new ConnectPoint((ElementId)D1, P2)));
    }

    @Test
    public void clusterRelated() {
        Set clusters = this.dt.getClusters();
        Assert.assertEquals((String)"incorrect cluster count", (long)2L, (long)clusters.size());
        TopologyCluster c = this.dt.getCluster(D1);
        Set devs = this.dt.getClusterDevices(c);
        Assert.assertEquals((String)"incorrect cluster device count", (long)4L, (long)devs.size());
        Assert.assertTrue((String)"cluster should contain D2", (boolean)devs.contains(D2));
        Assert.assertFalse((String)"cluster should not contain D5", (boolean)devs.contains(D5));
    }

    public static Link link(String src, int sp, String dst, int dp) {
        return new DefaultLink(PID, new ConnectPoint((ElementId)DefaultTopologyTest.did(src), PortNumber.portNumber((long)sp)), new ConnectPoint((ElementId)DefaultTopologyTest.did(dst), PortNumber.portNumber((long)dp)), Link.Type.DIRECT, new Annotations[0]);
    }

    public static Device device(String id) {
        return new DefaultDevice(PID, DefaultTopologyTest.did(id), Device.Type.SWITCH, "mfg", "1.0", "1.1", "1234", new ChassisId(), new Annotations[0]);
    }

    public static DeviceId did(String id) {
        return DeviceId.deviceId((String)("of:" + id));
    }
}

