/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.common.app.ApplicationArchive;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStoreAdapter;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.Permission;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.trivial.impl.SimpleApplicationStore;

public class SimpleApplicationStoreTest {
    private SimpleApplicationStore store = new SimpleApplicationStore();
    private TestDelegate delegate = new TestDelegate();

    @Before
    public void setUp() {
        this.store.idStore = new TestIdStore();
        this.store.setDelegate((StoreDelegate)this.delegate);
        this.store.activate();
    }

    @After
    public void tearDown() {
        this.store.deactivate();
    }

    private Application createTestApp() {
        return this.store.create(ApplicationArchive.class.getResourceAsStream("app.zip"));
    }

    @Test
    public void create() {
        Application app = this.createTestApp();
        Assert.assertEquals((String)"incorrect name", (Object)"org.foo.app", (Object)app.id().name());
        Assert.assertEquals((String)"incorrect app count", (long)1L, (long)this.store.getApplications().size());
        Assert.assertEquals((String)"incorrect app", (Object)app, (Object)this.store.getApplication(app.id()));
        Assert.assertEquals((String)"incorrect app state", (Object)ApplicationState.INSTALLED, (Object)this.store.getState(app.id()));
        Assert.assertEquals((String)"incorrect event type", (Object)ApplicationEvent.Type.APP_INSTALLED, (Object)this.delegate.event.type());
        Assert.assertEquals((String)"incorrect event app", (Object)app, (Object)this.delegate.event.subject());
    }

    @Test
    public void remove() {
        Application app = this.createTestApp();
        this.store.remove(app.id());
        Assert.assertEquals((String)"incorrect app count", (long)0L, (long)this.store.getApplications().size());
        Assert.assertEquals((String)"incorrect event type", (Object)ApplicationEvent.Type.APP_UNINSTALLED, (Object)this.delegate.event.type());
        Assert.assertEquals((String)"incorrect event app", (Object)app, (Object)this.delegate.event.subject());
    }

    @Test
    public void activate() {
        Application app = this.createTestApp();
        this.store.activate(app.id());
        Assert.assertEquals((String)"incorrect app count", (long)1L, (long)this.store.getApplications().size());
        Assert.assertEquals((String)"incorrect app state", (Object)ApplicationState.ACTIVE, (Object)this.store.getState(app.id()));
        Assert.assertEquals((String)"incorrect event type", (Object)ApplicationEvent.Type.APP_ACTIVATED, (Object)this.delegate.event.type());
        Assert.assertEquals((String)"incorrect event app", (Object)app, (Object)this.delegate.event.subject());
    }

    @Test
    public void deactivate() {
        Application app = this.createTestApp();
        this.store.deactivate(app.id());
        Assert.assertEquals((String)"incorrect app count", (long)1L, (long)this.store.getApplications().size());
        Assert.assertEquals((String)"incorrect app state", (Object)ApplicationState.INSTALLED, (Object)this.store.getState(app.id()));
        Assert.assertEquals((String)"incorrect event type", (Object)ApplicationEvent.Type.APP_DEACTIVATED, (Object)this.delegate.event.type());
        Assert.assertEquals((String)"incorrect event app", (Object)app, (Object)this.delegate.event.subject());
    }

    @Test
    public void permissions() {
        Application app = this.createTestApp();
        ImmutableSet permissions = ImmutableSet.of((Object)Permission.FLOWRULE_WRITE);
        this.store.setPermissions(app.id(), (Set)permissions);
        Assert.assertEquals((String)"incorrect app perms", (long)1L, (long)this.store.getPermissions(app.id()).size());
        Assert.assertEquals((String)"incorrect app state", (Object)ApplicationState.INSTALLED, (Object)this.store.getState(app.id()));
        Assert.assertEquals((String)"incorrect event type", (Object)ApplicationEvent.Type.APP_PERMISSIONS_CHANGED, (Object)this.delegate.event.type());
        Assert.assertEquals((String)"incorrect event app", (Object)app, (Object)this.delegate.event.subject());
    }

    private class TestDelegate
    implements ApplicationStoreDelegate {
        private ApplicationEvent event;

        private TestDelegate() {
        }

        public void notify(ApplicationEvent event) {
            this.event = event;
        }
    }

    private class TestIdStore
    extends ApplicationIdStoreAdapter {
        private TestIdStore() {
        }

        public ApplicationId registerApplication(String name) {
            return new DefaultApplicationId(1, name);
        }

        public ApplicationId getAppId(String name) {
            return new DefaultApplicationId(1, name);
        }
    }
}

