/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.ChassisId;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceStore;
import org.onosproject.net.device.DeviceStoreDelegate;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.trivial.impl.SimpleDeviceStore;

public class SimpleDeviceStoreTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final ProviderId PIDA = new ProviderId("of", "bar", true);
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final String MFR = "whitebox";
    private static final String HW = "1.1.x";
    private static final String SW1 = "3.8.1";
    private static final String SW2 = "3.9.5";
    private static final String SN = "43311-12345";
    private static final ChassisId CID = new ChassisId();
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final SparseAnnotations A1 = DefaultAnnotations.builder().set("A1", "a1").set("B1", "b1").build();
    private static final SparseAnnotations A1_2 = DefaultAnnotations.builder().remove("A1").set("B3", "b3").build();
    private static final SparseAnnotations A2 = DefaultAnnotations.builder().set("A2", "a2").set("B2", "b2").build();
    private static final SparseAnnotations A2_2 = DefaultAnnotations.builder().remove("A2").set("B4", "b4").build();
    private SimpleDeviceStore simpleDeviceStore;
    private DeviceStore deviceStore;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.simpleDeviceStore = new SimpleDeviceStore();
        this.simpleDeviceStore.activate();
        this.deviceStore = this.simpleDeviceStore;
    }

    @After
    public void tearDown() throws Exception {
        this.simpleDeviceStore.deactivate();
    }

    private void putDevice(DeviceId deviceId, String swVersion, SparseAnnotations ... annotations) {
        DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, MFR, HW, swVersion, SN, CID, annotations);
        this.deviceStore.createOrUpdateDevice(PID, deviceId, (DeviceDescription)description);
    }

    private void putDeviceAncillary(DeviceId deviceId, String swVersion, SparseAnnotations ... annotations) {
        DefaultDeviceDescription description = new DefaultDeviceDescription(deviceId.uri(), Device.Type.SWITCH, MFR, HW, swVersion, SN, CID, annotations);
        this.deviceStore.createOrUpdateDevice(PIDA, deviceId, (DeviceDescription)description);
    }

    private static void assertDevice(DeviceId id, String swVersion, Device device) {
        Assert.assertNotNull((Object)device);
        Assert.assertEquals((Object)id, (Object)device.id());
        Assert.assertEquals((Object)MFR, (Object)device.manufacturer());
        Assert.assertEquals((Object)HW, (Object)device.hwVersion());
        Assert.assertEquals((Object)swVersion, (Object)device.swVersion());
        Assert.assertEquals((Object)SN, (Object)device.serialNumber());
    }

    @Test
    public final void testGetDeviceCount() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)this.deviceStore.getDeviceCount());
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW2, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expect 2 uniq devices", (long)2L, (long)this.deviceStore.getDeviceCount());
    }

    @Test
    public final void testGetDevices() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)Iterables.size((Iterable)this.deviceStore.getDevices()));
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW2, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expect 2 uniq devices", (long)2L, (long)Iterables.size((Iterable)this.deviceStore.getDevices()));
        HashMap<DeviceId, Device> devices = new HashMap<DeviceId, Device>();
        for (Device device : this.deviceStore.getDevices()) {
            devices.put(device.id(), device);
        }
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)devices.get(DID1));
        SimpleDeviceStoreTest.assertDevice(DID2, SW2, (Device)devices.get(DID2));
    }

    @Test
    public final void testGetDevice() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, this.deviceStore.getDevice(DID1));
        Assert.assertNull((String)"DID2 shouldn't be there", (Object)this.deviceStore.getDevice(DID2));
    }

    @Test
    public final void testCreateOrUpdateDevice() {
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[0]);
        DeviceEvent event = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[0]);
        DeviceEvent event2 = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event2.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW2, (Device)event2.subject());
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2));
    }

    @Test
    public final void testCreateOrUpdateDeviceAncillary() {
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[]{A2});
        DeviceEvent event = this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)PIDA, (Object)((Device)event.subject()).providerId());
        NetTestTools.assertAnnotationsEquals((Annotations)((Device)event.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2});
        Assert.assertFalse((String)"Ancillary will not bring device up", (boolean)this.deviceStore.isAvailable(DID1));
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[]{A1});
        DeviceEvent event2 = this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event2.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW2, (Device)event2.subject());
        Assert.assertEquals((Object)PID, (Object)((Device)event2.subject()).providerId());
        NetTestTools.assertAnnotationsEquals((Annotations)((Device)event2.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1, A2});
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2));
        Assert.assertNull((String)"No change expected", (Object)this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description));
        DefaultDeviceDescription description3 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[]{A2_2});
        DeviceEvent event3 = this.deviceStore.createOrUpdateDevice(PIDA, DID1, (DeviceDescription)description3);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event3.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW2, (Device)event3.subject());
        Assert.assertEquals((Object)PID, (Object)((Device)event3.subject()).providerId());
        NetTestTools.assertAnnotationsEquals((Annotations)((Device)event3.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1, A2, A2_2});
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
    }

    @Test
    public final void testMarkOffline() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        Assert.assertTrue((boolean)this.deviceStore.isAvailable(DID1));
        DeviceEvent event = this.deviceStore.markOffline(DID1);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertFalse((boolean)this.deviceStore.isAvailable(DID1));
        DeviceEvent event2 = this.deviceStore.markOffline(DID1);
        Assert.assertNull((String)"No change, no event", (Object)event2);
    }

    @Test
    public final void testUpdatePorts() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        List events = this.deviceStore.updatePorts(PID, DID1, pds);
        HashSet expectedPorts = Sets.newHashSet((Object[])new PortNumber[]{P1, P2});
        for (Object event : events) {
            Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event.type());
            SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
            Assert.assertTrue((String)"PortNumber is one of expected", (boolean)expectedPorts.remove(event.port().number()));
            Assert.assertTrue((String)"Port is enabled", (boolean)event.port().isEnabled());
        }
        Assert.assertTrue((String)"Event for all expectedport appeared", (boolean)expectedPorts.isEmpty());
        List<PortDescription> pds2 = Arrays.asList(new DefaultPortDescription(P1, false, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]), new DefaultPortDescription(P3, true, new SparseAnnotations[0]));
        events = this.deviceStore.updatePorts(PID, DID1, pds2);
        Assert.assertFalse((String)"event should be triggered", (boolean)events.isEmpty());
        for (DeviceEvent event : events) {
            PortNumber num = event.port().number();
            if (P1.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
                continue;
            }
            if (P2.equals((Object)num)) {
                Assert.fail((String)"P2 event not expected.");
                continue;
            }
            if (P3.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertTrue((String)"Port is enabled", (boolean)event.port().isEnabled());
                continue;
            }
            Assert.fail((String)("Unknown port number encountered: " + num));
        }
        List<PortDescription> pds3 = Arrays.asList(new DefaultPortDescription(P1, false, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        events = this.deviceStore.updatePorts(PID, DID1, pds3);
        Assert.assertFalse((String)"event should be triggered", (boolean)events.isEmpty());
        for (DeviceEvent event : events) {
            PortNumber num = event.port().number();
            if (P1.equals((Object)num)) {
                Assert.fail((String)"P1 event not expected.");
                continue;
            }
            if (P2.equals((Object)num)) {
                Assert.fail((String)"P2 event not expected.");
                continue;
            }
            if (P3.equals((Object)num)) {
                Assert.assertEquals((Object)DeviceEvent.Type.PORT_REMOVED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
                Assert.assertTrue((String)"Port was enabled", (boolean)event.port().isEnabled());
                continue;
            }
            Assert.fail((String)("Unknown port number encountered: " + num));
        }
    }

    @Test
    public final void testUpdatePortStatus() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        DeviceEvent event = this.deviceStore.updatePortStatus(PID, DID1, (PortDescription)new DefaultPortDescription(P1, false, new SparseAnnotations[0]));
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)P1, (Object)event.port().number());
        Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
    }

    @Test
    public final void testUpdatePortStatusAncillary() {
        this.putDeviceAncillary(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[]{A1}));
        this.deviceStore.updatePorts(PID, DID1, pds);
        DeviceEvent event = this.deviceStore.updatePortStatus(PID, DID1, (PortDescription)new DefaultPortDescription(P1, false, new SparseAnnotations[]{A1_2}));
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((Object)P1, (Object)event.port().number());
        NetTestTools.assertAnnotationsEquals((Annotations)event.port().annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1, A1_2});
        Assert.assertFalse((String)"Port is disabled", (boolean)event.port().isEnabled());
        DeviceEvent event2 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)new DefaultPortDescription(P1, true, new SparseAnnotations[0]));
        Assert.assertNull((String)"Ancillary is ignored if primary exists", (Object)event2);
        DeviceEvent event3 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)new DefaultPortDescription(P1, true, new SparseAnnotations[]{A2}));
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_UPDATED, (Object)event3.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event3.subject());
        Assert.assertEquals((Object)P1, (Object)event3.port().number());
        NetTestTools.assertAnnotationsEquals((Annotations)event3.port().annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1, A1_2, A2});
        Assert.assertFalse((String)"Port is disabled", (boolean)event3.port().isEnabled());
        DeviceEvent event4 = this.deviceStore.updatePortStatus(PIDA, DID1, (PortDescription)new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        Assert.assertEquals((Object)DeviceEvent.Type.PORT_ADDED, (Object)event4.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event4.subject());
        Assert.assertEquals((Object)P2, (Object)event4.port().number());
        NetTestTools.assertAnnotationsEquals((Annotations)event4.port().annotations(), (SparseAnnotations[])new SparseAnnotations[0]);
        Assert.assertFalse((String)"Port is disabled if not given from primary provider", (boolean)event4.port().isEnabled());
    }

    @Test
    public final void testGetPorts() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        HashSet expectedPorts = Sets.newHashSet((Object[])new PortNumber[]{P1, P2});
        List ports = this.deviceStore.getPorts(DID1);
        for (Port port : ports) {
            Assert.assertTrue((String)"Port is enabled", (boolean)port.isEnabled());
            Assert.assertTrue((String)"PortNumber is one of expected", (boolean)expectedPorts.remove(port.number()));
        }
        Assert.assertTrue((String)"Event for all expectedport appeared", (boolean)expectedPorts.isEmpty());
        Assert.assertTrue((String)"DID2 has no ports", (boolean)this.deviceStore.getPorts(DID2).isEmpty());
    }

    @Test
    public final void testGetPort() {
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]), new DefaultPortDescription(P2, false, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds);
        Port port1 = this.deviceStore.getPort(DID1, P1);
        Assert.assertEquals((Object)P1, (Object)port1.number());
        Assert.assertTrue((String)"Port is enabled", (boolean)port1.isEnabled());
        Port port2 = this.deviceStore.getPort(DID1, P2);
        Assert.assertEquals((Object)P2, (Object)port2.number());
        Assert.assertFalse((String)"Port is disabled", (boolean)port2.isEnabled());
        Port port3 = this.deviceStore.getPort(DID1, P3);
        Assert.assertNull((String)"P3 not expected", (Object)port3);
    }

    @Test
    public final void testRemoveDevice() {
        this.putDevice(DID1, SW1, A1);
        List<PortDescription> pds = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[]{A2}));
        this.deviceStore.updatePorts(PID, DID1, pds);
        this.putDevice(DID2, SW1, new SparseAnnotations[0]);
        Assert.assertEquals((long)2L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getPorts(DID1).size());
        NetTestTools.assertAnnotationsEquals((Annotations)this.deviceStore.getDevice(DID1).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1});
        NetTestTools.assertAnnotationsEquals((Annotations)this.deviceStore.getPort(DID1, P1).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2});
        DeviceEvent event = this.deviceStore.removeDevice(DID1);
        Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_REMOVED, (Object)event.type());
        SimpleDeviceStoreTest.assertDevice(DID1, SW1, (Device)event.subject());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)0L, (long)this.deviceStore.getPorts(DID1).size());
        this.putDevice(DID1, SW1, new SparseAnnotations[0]);
        List<PortDescription> pds2 = Arrays.asList(new DefaultPortDescription(P1, true, new SparseAnnotations[0]));
        this.deviceStore.updatePorts(PID, DID1, pds2);
        Assert.assertEquals((long)2L, (long)this.deviceStore.getDeviceCount());
        Assert.assertEquals((long)1L, (long)this.deviceStore.getPorts(DID1).size());
        NetTestTools.assertAnnotationsEquals((Annotations)this.deviceStore.getDevice(DID1).annotations(), (SparseAnnotations[])new SparseAnnotations[0]);
        NetTestTools.assertAnnotationsEquals((Annotations)this.deviceStore.getPort(DID1, P1).annotations(), (SparseAnnotations[])new SparseAnnotations[0]);
    }

    @Ignore(value="Ignore until Delegate spec. is clear.")
    @Test
    public final void testEvents() throws InterruptedException {
        final CountDownLatch addLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkAdd = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_ADDED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SimpleDeviceStoreTest.SW1, (Device)event.subject());
                addLatch.countDown();
            }
        };
        final CountDownLatch updateLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkUpdate = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_UPDATED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SimpleDeviceStoreTest.SW2, (Device)event.subject());
                updateLatch.countDown();
            }
        };
        final CountDownLatch removeLatch = new CountDownLatch(1);
        DeviceStoreDelegate checkRemove = new DeviceStoreDelegate(){

            public void notify(DeviceEvent event) {
                Assert.assertEquals((Object)DeviceEvent.Type.DEVICE_REMOVED, (Object)event.type());
                SimpleDeviceStoreTest.assertDevice(DID1, SimpleDeviceStoreTest.SW2, (Device)event.subject());
                removeLatch.countDown();
            }
        };
        DefaultDeviceDescription description = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW1, SN, CID, new SparseAnnotations[0]);
        this.deviceStore.setDelegate((StoreDelegate)checkAdd);
        this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description);
        Assert.assertTrue((String)"Add event fired", (boolean)addLatch.await(1L, TimeUnit.SECONDS));
        DefaultDeviceDescription description2 = new DefaultDeviceDescription(DID1.uri(), Device.Type.SWITCH, MFR, HW, SW2, SN, CID, new SparseAnnotations[0]);
        this.deviceStore.unsetDelegate((StoreDelegate)checkAdd);
        this.deviceStore.setDelegate((StoreDelegate)checkUpdate);
        this.deviceStore.createOrUpdateDevice(PID, DID1, (DeviceDescription)description2);
        Assert.assertTrue((String)"Update event fired", (boolean)updateLatch.await(1L, TimeUnit.SECONDS));
        this.deviceStore.unsetDelegate((StoreDelegate)checkUpdate);
        this.deviceStore.setDelegate((StoreDelegate)checkRemove);
        this.deviceStore.removeDevice(DID1);
        Assert.assertTrue((String)"Remove event fired", (boolean)removeLatch.await(1L, TimeUnit.SECONDS));
    }
}

