/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.net.group.StoredGroupBucketEntry;
import org.onosproject.net.group.StoredGroupEntry;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.trivial.impl.SimpleGroupStore;

public class SimpleGroupStoreTest {
    private SimpleGroupStore simpleGroupStore;
    private final ApplicationId appId = new DefaultApplicationId(2, "org.groupstore.test");
    public static final DeviceId D1 = DeviceId.deviceId((String)"of:1");

    @Before
    public void setUp() throws Exception {
        this.simpleGroupStore = new SimpleGroupStore();
        this.simpleGroupStore.activate();
    }

    @After
    public void tearDown() throws Exception {
        this.simpleGroupStore.deactivate();
    }

    @Test
    public void testGroupStoreOperations() {
        this.simpleGroupStore.deviceInitialAuditCompleted(D1, true);
        DefaultGroupKey newKey = new DefaultGroupKey("group1".getBytes());
        this.testStoreAndGetGroup((GroupKey)newKey);
        DefaultGroupKey currKey = newKey;
        this.testAddGroupEntryFromSB((GroupKey)currKey);
        newKey = new DefaultGroupKey("group1AddBuckets".getBytes());
        this.testAddBuckets((GroupKey)currKey, (GroupKey)newKey);
        currKey = newKey;
        newKey = new DefaultGroupKey("group1RemoveBuckets".getBytes());
        this.testRemoveBuckets((GroupKey)currKey, (GroupKey)newKey);
        currKey = newKey;
        this.testUpdateGroupEntryFromSB((GroupKey)currKey);
        this.testDeleteGroup((GroupKey)currKey);
        this.testRemoveGroupFromSB((GroupKey)currKey);
    }

    private void testStoreAndGetGroup(GroupKey key) {
        PortNumber[] ports = new PortNumber[]{PortNumber.portNumber((long)31L), PortNumber.portNumber((long)32L)};
        ArrayList<PortNumber> outPorts = new ArrayList<PortNumber>();
        outPorts.addAll(Arrays.asList(ports));
        ArrayList<GroupBucket> buckets = new ArrayList<GroupBucket>();
        for (PortNumber portNumber : outPorts) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            tBuilder.setOutput(portNumber).setEthDst(MacAddress.valueOf((String)"00:00:00:00:00:02")).setEthSrc(MacAddress.valueOf((String)"00:00:00:00:00:01")).pushMpls().setMpls(MplsLabel.mplsLabel((int)106));
            buckets.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder.build()));
        }
        GroupBuckets groupBuckets = new GroupBuckets(buckets);
        DefaultGroupDescription groupDesc = new DefaultGroupDescription(D1, GroupDescription.Type.SELECT, groupBuckets, key, null, this.appId);
        InternalGroupStoreDelegate checkStoreGroupDelegate = new InternalGroupStoreDelegate(key, groupBuckets, GroupEvent.Type.GROUP_ADD_REQUESTED);
        this.simpleGroupStore.setDelegate((StoreDelegate)checkStoreGroupDelegate);
        this.simpleGroupStore.storeGroupDescription((GroupDescription)groupDesc);
        Assert.assertEquals((long)1L, (long)this.simpleGroupStore.getGroupCount(D1));
        Group createdGroup = this.simpleGroupStore.getGroup(D1, key);
        checkStoreGroupDelegate.verifyGroupId(createdGroup.id());
        Iterable createdGroups = this.simpleGroupStore.getGroups(D1);
        int groupCount = 0;
        for (Group group : createdGroups) {
            checkStoreGroupDelegate.verifyGroupId(group.id());
            ++groupCount;
        }
        Assert.assertEquals((long)1L, (long)groupCount);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)checkStoreGroupDelegate);
    }

    private void testAddGroupEntryFromSB(GroupKey currKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        InternalGroupStoreDelegate addGroupEntryDelegate = new InternalGroupStoreDelegate(currKey, existingGroup.buckets(), GroupEvent.Type.GROUP_ADDED);
        this.simpleGroupStore.setDelegate((StoreDelegate)addGroupEntryDelegate);
        this.simpleGroupStore.addOrUpdateGroupEntry(existingGroup);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)addGroupEntryDelegate);
    }

    private void testUpdateGroupEntryFromSB(GroupKey currKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        int totalPkts = 0;
        int totalBytes = 0;
        ArrayList<StoredGroupBucketEntry> newBucketList = new ArrayList<StoredGroupBucketEntry>();
        for (GroupBucket bucket : existingGroup.buckets().buckets()) {
            StoredGroupBucketEntry newBucket = (StoredGroupBucketEntry)DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)bucket.treatment());
            newBucket.setPackets(10L);
            newBucket.setBytes(20480L);
            totalPkts += 10;
            totalBytes += 20480;
            newBucketList.add(newBucket);
        }
        GroupBuckets updatedBuckets = new GroupBuckets(newBucketList);
        DefaultGroup updatedGroup = new DefaultGroup(existingGroup.id(), existingGroup.deviceId(), existingGroup.type(), updatedBuckets);
        ((StoredGroupEntry)updatedGroup).setPackets((long)totalPkts);
        ((StoredGroupEntry)updatedGroup).setBytes((long)totalBytes);
        InternalGroupStoreDelegate updateGroupEntryDelegate = new InternalGroupStoreDelegate(currKey, updatedBuckets, GroupEvent.Type.GROUP_UPDATED);
        this.simpleGroupStore.setDelegate((StoreDelegate)updateGroupEntryDelegate);
        this.simpleGroupStore.addOrUpdateGroupEntry((Group)updatedGroup);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)updateGroupEntryDelegate);
    }

    private void testAddBuckets(GroupKey currKey, GroupKey addKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        ArrayList buckets = new ArrayList();
        buckets.addAll(existingGroup.buckets().buckets());
        PortNumber[] newNeighborPorts = new PortNumber[]{PortNumber.portNumber((long)41L), PortNumber.portNumber((long)42L)};
        ArrayList<PortNumber> newOutPorts = new ArrayList<PortNumber>();
        newOutPorts.addAll(Collections.singletonList(newNeighborPorts[0]));
        ArrayList<GroupBucket> toAddBuckets = new ArrayList<GroupBucket>();
        for (PortNumber portNumber : newOutPorts) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            tBuilder.setOutput(portNumber).setEthDst(MacAddress.valueOf((String)"00:00:00:00:00:03")).setEthSrc(MacAddress.valueOf((String)"00:00:00:00:00:01")).pushMpls().setMpls(MplsLabel.mplsLabel((int)106));
            toAddBuckets.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder.build()));
        }
        GroupBuckets toAddGroupBuckets = new GroupBuckets(toAddBuckets);
        buckets.addAll(toAddBuckets);
        GroupBuckets updatedGroupBuckets = new GroupBuckets(buckets);
        InternalGroupStoreDelegate updateGroupDescDelegate = new InternalGroupStoreDelegate(addKey, updatedGroupBuckets, GroupEvent.Type.GROUP_UPDATE_REQUESTED);
        this.simpleGroupStore.setDelegate((StoreDelegate)updateGroupDescDelegate);
        this.simpleGroupStore.updateGroupDescription(D1, currKey, GroupStore.UpdateType.ADD, toAddGroupBuckets, addKey);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)updateGroupDescDelegate);
    }

    private void testRemoveBuckets(GroupKey currKey, GroupKey removeKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        ArrayList buckets = new ArrayList();
        buckets.addAll(existingGroup.buckets().buckets());
        ArrayList toRemoveBuckets = new ArrayList();
        toRemoveBuckets.add(buckets.remove(0));
        toRemoveBuckets.add(buckets.remove(1));
        GroupBuckets toRemoveGroupBuckets = new GroupBuckets(toRemoveBuckets);
        GroupBuckets remainingGroupBuckets = new GroupBuckets(buckets);
        InternalGroupStoreDelegate removeGroupDescDelegate = new InternalGroupStoreDelegate(removeKey, remainingGroupBuckets, GroupEvent.Type.GROUP_UPDATE_REQUESTED);
        this.simpleGroupStore.setDelegate((StoreDelegate)removeGroupDescDelegate);
        this.simpleGroupStore.updateGroupDescription(D1, currKey, GroupStore.UpdateType.REMOVE, toRemoveGroupBuckets, removeKey);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)removeGroupDescDelegate);
    }

    private void testDeleteGroup(GroupKey currKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        InternalGroupStoreDelegate deleteGroupDescDelegate = new InternalGroupStoreDelegate(currKey, existingGroup.buckets(), GroupEvent.Type.GROUP_REMOVE_REQUESTED);
        this.simpleGroupStore.setDelegate((StoreDelegate)deleteGroupDescDelegate);
        this.simpleGroupStore.deleteGroupDescription(D1, currKey);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)deleteGroupDescDelegate);
    }

    private void testRemoveGroupFromSB(GroupKey currKey) {
        Group existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        InternalGroupStoreDelegate removeGroupEntryDelegate = new InternalGroupStoreDelegate(currKey, existingGroup.buckets(), GroupEvent.Type.GROUP_REMOVED);
        this.simpleGroupStore.setDelegate((StoreDelegate)removeGroupEntryDelegate);
        this.simpleGroupStore.removeGroupEntry(existingGroup);
        existingGroup = this.simpleGroupStore.getGroup(D1, currKey);
        Assert.assertEquals(null, (Object)existingGroup);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.simpleGroupStore.getGroups(D1)));
        Assert.assertEquals((long)0L, (long)this.simpleGroupStore.getGroupCount(D1));
        this.simpleGroupStore.unsetDelegate((StoreDelegate)removeGroupEntryDelegate);
    }

    @Test
    public void testGroupOperationFailure() {
        this.simpleGroupStore.deviceInitialAuditCompleted(D1, true);
        DefaultApplicationId appId = new DefaultApplicationId(2, "org.groupstore.test");
        DefaultGroupKey key = new DefaultGroupKey("group1".getBytes());
        PortNumber[] ports = new PortNumber[]{PortNumber.portNumber((long)31L), PortNumber.portNumber((long)32L)};
        ArrayList<PortNumber> outPorts = new ArrayList<PortNumber>();
        outPorts.add(ports[0]);
        outPorts.add(ports[1]);
        ArrayList<GroupBucket> buckets = new ArrayList<GroupBucket>();
        for (PortNumber portNumber : outPorts) {
            TrafficTreatment.Builder tBuilder = DefaultTrafficTreatment.builder();
            tBuilder.setOutput(portNumber).setEthDst(MacAddress.valueOf((String)"00:00:00:00:00:02")).setEthSrc(MacAddress.valueOf((String)"00:00:00:00:00:01")).pushMpls().setMpls(MplsLabel.mplsLabel((int)106));
            buckets.add(DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)tBuilder.build()));
        }
        GroupBuckets groupBuckets = new GroupBuckets(buckets);
        DefaultGroupDescription groupDesc = new DefaultGroupDescription(D1, GroupDescription.Type.SELECT, groupBuckets, (GroupKey)key, null, (ApplicationId)appId);
        InternalGroupStoreDelegate checkStoreGroupDelegate = new InternalGroupStoreDelegate((GroupKey)key, groupBuckets, GroupEvent.Type.GROUP_ADD_REQUESTED);
        this.simpleGroupStore.setDelegate((StoreDelegate)checkStoreGroupDelegate);
        this.simpleGroupStore.storeGroupDescription((GroupDescription)groupDesc);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)checkStoreGroupDelegate);
        Group createdGroup = this.simpleGroupStore.getGroup(D1, (GroupKey)key);
        checkStoreGroupDelegate.verifyGroupId(createdGroup.id());
        GroupOperation groupAddOp = GroupOperation.createAddGroupOperation((GroupId)createdGroup.id(), (GroupDescription.Type)createdGroup.type(), (GroupBuckets)createdGroup.buckets());
        InternalGroupStoreDelegate checkGroupAddFailureDelegate = new InternalGroupStoreDelegate((GroupKey)key, groupBuckets, GroupEvent.Type.GROUP_ADD_FAILED);
        this.simpleGroupStore.setDelegate((StoreDelegate)checkGroupAddFailureDelegate);
        this.simpleGroupStore.groupOperationFailed(D1, groupAddOp);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)checkGroupAddFailureDelegate);
        GroupOperation groupModOp = GroupOperation.createModifyGroupOperation((GroupId)createdGroup.id(), (GroupDescription.Type)createdGroup.type(), (GroupBuckets)createdGroup.buckets());
        InternalGroupStoreDelegate checkGroupModFailureDelegate = new InternalGroupStoreDelegate((GroupKey)key, groupBuckets, GroupEvent.Type.GROUP_UPDATE_FAILED);
        this.simpleGroupStore.setDelegate((StoreDelegate)checkGroupModFailureDelegate);
        this.simpleGroupStore.groupOperationFailed(D1, groupModOp);
        this.simpleGroupStore.unsetDelegate((StoreDelegate)checkGroupModFailureDelegate);
        GroupOperation groupDelOp = GroupOperation.createDeleteGroupOperation((GroupId)createdGroup.id(), (GroupDescription.Type)createdGroup.type());
        InternalGroupStoreDelegate checkGroupDelFailureDelegate = new InternalGroupStoreDelegate((GroupKey)key, groupBuckets, GroupEvent.Type.GROUP_REMOVE_FAILED);
        this.simpleGroupStore.setDelegate((StoreDelegate)checkGroupDelFailureDelegate);
        this.simpleGroupStore.groupOperationFailed(D1, groupDelOp);
    }

    private class InternalGroupStoreDelegate
    implements GroupStoreDelegate {
        private GroupId createdGroupId = null;
        private GroupKey createdGroupKey;
        private GroupBuckets createdBuckets;
        private GroupEvent.Type expectedEvent;

        public InternalGroupStoreDelegate(GroupKey key, GroupBuckets buckets, GroupEvent.Type expectedEvent) {
            this.createdBuckets = buckets;
            this.createdGroupKey = key;
            this.expectedEvent = expectedEvent;
        }

        public void notify(GroupEvent event) {
            Assert.assertEquals((Object)this.expectedEvent, (Object)event.type());
            Assert.assertEquals((Object)GroupDescription.Type.SELECT, (Object)((Group)event.subject()).type());
            Assert.assertEquals((Object)D1, (Object)((Group)event.subject()).deviceId());
            Assert.assertEquals((Object)this.createdGroupKey, (Object)((Group)event.subject()).appCookie());
            Assert.assertEquals((Object)this.createdBuckets.buckets(), (Object)((Group)event.subject()).buckets().buckets());
            if (this.expectedEvent == GroupEvent.Type.GROUP_ADD_REQUESTED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.PENDING_ADD, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_ADDED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.ADDED, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_UPDATED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)true, (Object)((Group)event.subject()).buckets().buckets().containsAll(this.createdBuckets.buckets()));
                Assert.assertEquals((Object)true, (Object)this.createdBuckets.buckets().containsAll(((Group)event.subject()).buckets().buckets()));
                for (GroupBucket bucket : ((Group)event.subject()).buckets().buckets()) {
                    Optional<GroupBucket> matched = this.createdBuckets.buckets().stream().filter(expected -> expected.equals(bucket)).findFirst();
                    Assert.assertEquals((long)matched.get().packets(), (long)bucket.packets());
                    Assert.assertEquals((long)matched.get().bytes(), (long)bucket.bytes());
                }
                Assert.assertEquals((Object)Group.GroupState.ADDED, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_UPDATE_REQUESTED) {
                Assert.assertEquals((Object)Group.GroupState.PENDING_UPDATE, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_REMOVE_REQUESTED) {
                Assert.assertEquals((Object)Group.GroupState.PENDING_DELETE, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_REMOVED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.PENDING_DELETE, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_ADD_FAILED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.PENDING_ADD, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_UPDATE_FAILED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.PENDING_UPDATE, (Object)((Group)event.subject()).state());
            } else if (this.expectedEvent == GroupEvent.Type.GROUP_REMOVE_FAILED) {
                this.createdGroupId = ((Group)event.subject()).id();
                Assert.assertEquals((Object)Group.GroupState.PENDING_DELETE, (Object)((Group)event.subject()).state());
            }
        }

        public void verifyGroupId(GroupId id) {
            Assert.assertEquals((Object)this.createdGroupId, (Object)id);
        }
    }
}

