/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceAllocationException;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceAllocation;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LambdaResourceAllocation;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceStore;
import org.onosproject.store.trivial.impl.SimpleLinkResourceStore;

public class SimpleLinkResourceStoreTest {
    private LinkResourceStore store;
    private SimpleLinkResourceStore simpleStore;
    private Link link1;
    private Link link2;
    private Link link3;

    private static Link newLink(String dev1, int port1, String dev2, int port2) {
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("optical.waves", "80").set("bandwidth", "1000").build();
        return new DefaultLink(new ProviderId("of", "foo"), new ConnectPoint((ElementId)DeviceId.deviceId((String)dev1), PortNumber.portNumber((long)port1)), new ConnectPoint((ElementId)DeviceId.deviceId((String)dev2), PortNumber.portNumber((long)port2)), Link.Type.DIRECT, new Annotations[]{annotations});
    }

    @Before
    public void setUp() throws Exception {
        this.simpleStore = new SimpleLinkResourceStore();
        this.simpleStore.activate();
        this.store = this.simpleStore;
        this.link1 = SimpleLinkResourceStoreTest.newLink("of:1", 1, "of:2", 2);
        this.link2 = SimpleLinkResourceStoreTest.newLink("of:2", 1, "of:3", 2);
        this.link3 = SimpleLinkResourceStoreTest.newLink("of:3", 1, "of:4", 2);
    }

    @After
    public void tearDown() throws Exception {
        this.simpleStore.deactivate();
    }

    @Test
    public void testConstructorAndActivate() {
        Iterable allAllocations = this.store.getAllocations();
        Assert.assertNotNull((Object)allAllocations);
        Assert.assertFalse((boolean)allAllocations.iterator().hasNext());
        Iterable linkAllocations = this.store.getAllocations(this.link1);
        Assert.assertNotNull((Object)linkAllocations);
        Assert.assertFalse((boolean)linkAllocations.iterator().hasNext());
        Set res = this.store.getFreeResources(this.link2);
        Assert.assertNotNull((Object)res);
    }

    private BandwidthResourceAllocation getBandwidthObj(Set<ResourceAllocation> resources) {
        for (ResourceAllocation res : resources) {
            if (res.type() != ResourceType.BANDWIDTH) continue;
            return (BandwidthResourceAllocation)res;
        }
        return null;
    }

    private Set<LambdaResourceAllocation> getLambdaObjs(Set<ResourceAllocation> resources) {
        HashSet<LambdaResourceAllocation> lambdaResources = new HashSet<LambdaResourceAllocation>();
        for (ResourceAllocation res : resources) {
            if (res.type() != ResourceType.LAMBDA) continue;
            lambdaResources.add((LambdaResourceAllocation)res);
        }
        return lambdaResources;
    }

    @Test
    public void testInitialBandwidth() {
        Set freeRes = this.store.getFreeResources(this.link1);
        Assert.assertNotNull((Object)freeRes);
        BandwidthResourceAllocation alloc = this.getBandwidthObj(freeRes);
        Assert.assertNotNull((Object)alloc);
        Assert.assertEquals((Object)new BandwidthResource(Bandwidth.mbps((double)1000.0)), (Object)alloc.bandwidth());
    }

    @Test
    public void testInitialLambdas() {
        Set freeRes = this.store.getFreeResources(this.link3);
        Assert.assertNotNull((Object)freeRes);
        Set<LambdaResourceAllocation> res = this.getLambdaObjs(freeRes);
        Assert.assertNotNull(res);
        Assert.assertEquals((long)80L, (long)res.size());
    }

    @Test
    public void testSuccessfulBandwidthAllocation() {
        MockLinkResourceBandwidthAllocations allocations = new MockLinkResourceBandwidthAllocations(900.0);
        this.store.allocateResources((LinkResourceAllocations)allocations);
    }

    @Test
    public void testUnsuccessfulBandwidthAllocation() {
        MockLinkResourceBandwidthAllocations allocations = new MockLinkResourceBandwidthAllocations(2.0E9);
        boolean gotException = false;
        try {
            this.store.allocateResources((LinkResourceAllocations)allocations);
        }
        catch (ResourceAllocationException rae) {
            Assert.assertEquals((Object)true, (Object)rae.getMessage().contains("Unable to allocate bandwidth for link"));
            gotException = true;
        }
        Assert.assertEquals((Object)true, (Object)gotException);
    }

    @Test
    public void testSuccessfulLambdaAllocation() {
        MockLinkResourceLambdaAllocations allocations = new MockLinkResourceLambdaAllocations(1);
        this.store.allocateResources((LinkResourceAllocations)allocations);
    }

    @Test
    public void testUnsuccessfulLambdaAllocation() {
        MockLinkResourceLambdaAllocations allocations = new MockLinkResourceLambdaAllocations(1);
        this.store.allocateResources((LinkResourceAllocations)allocations);
        boolean gotException = false;
        try {
            this.store.allocateResources((LinkResourceAllocations)allocations);
        }
        catch (ResourceAllocationException rae) {
            Assert.assertEquals((Object)true, (Object)rae.getMessage().contains("Unable to allocate lambda for link"));
            gotException = true;
        }
        Assert.assertEquals((Object)true, (Object)gotException);
    }

    public static class MockLinkResourceLambdaAllocations
    implements LinkResourceAllocations {
        final int allocatedLambda;

        MockLinkResourceLambdaAllocations(int allocatedLambda) {
            this.allocatedLambda = allocatedLambda;
        }

        public Set<ResourceAllocation> getResourceAllocation(Link link) {
            LambdaResourceAllocation allocation = new LambdaResourceAllocation(LambdaResource.valueOf((int)this.allocatedLambda));
            HashSet<ResourceAllocation> allocations = new HashSet<ResourceAllocation>();
            allocations.add((ResourceAllocation)allocation);
            return allocations;
        }

        public IntentId intentId() {
            return null;
        }

        public Collection<Link> links() {
            return ImmutableSet.of((Object)SimpleLinkResourceStoreTest.newLink("of:1", 1, "of:2", 2));
        }

        public Set<ResourceRequest> resources() {
            return null;
        }

        public ResourceType type() {
            return null;
        }
    }

    public static class MockLinkResourceBandwidthAllocations
    implements LinkResourceAllocations {
        final double allocationAmount;

        MockLinkResourceBandwidthAllocations(Double allocationAmount) {
            this.allocationAmount = allocationAmount;
        }

        public Set<ResourceAllocation> getResourceAllocation(Link link) {
            BandwidthResourceAllocation allocation = new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)this.allocationAmount)));
            HashSet<ResourceAllocation> allocations = new HashSet<ResourceAllocation>();
            allocations.add((ResourceAllocation)allocation);
            return allocations;
        }

        public IntentId intentId() {
            return null;
        }

        public Collection<Link> links() {
            return ImmutableSet.of((Object)SimpleLinkResourceStoreTest.newLink("of:1", 1, "of:2", 2));
        }

        public Set<ResourceRequest> resources() {
            return null;
        }

        public ResourceType type() {
            return null;
        }
    }
}

