/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.trivial.impl;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipEvent;
import org.onosproject.mastership.MastershipTerm;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.store.trivial.impl.SimpleMastershipStore;

public class SimpleMastershipStoreTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:01");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:02");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:03");
    private static final DeviceId DID4 = DeviceId.deviceId((String)"of:04");
    private static final NodeId N1 = new NodeId("local");
    private static final NodeId N2 = new NodeId("other");
    private SimpleMastershipStore sms;

    @Before
    public void setUp() throws Exception {
        this.sms = new SimpleMastershipStore();
        this.sms.activate();
    }

    @After
    public void tearDown() throws Exception {
        this.sms.deactivate();
    }

    @Test
    public void getRole() {
        this.put(DID1, N1, false, false);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.NONE, (Object)this.sms.getRole(N1, DID1));
        this.put(DID2, N1, false, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.STANDBY, (Object)this.sms.getRole(N1, DID2));
        this.put(DID3, N2, true, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)this.sms.getRole(N2, DID3));
        this.put(DID4, N1, false, true);
        this.put(DID4, N2, true, false);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.STANDBY, (Object)this.sms.getRole(N1, DID4));
    }

    @Test
    public void getMaster() {
        this.put(DID3, N2, true, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)this.sms.getRole(N2, DID3));
        Assert.assertEquals((String)"wrong device", (Object)N2, (Object)this.sms.getMaster(DID3));
    }

    @Test
    public void setMaster() {
        this.put(DID1, N1, false, false);
        Assert.assertEquals((String)"wrong event", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)((MastershipEvent)Futures.getUnchecked((Future)this.sms.setMaster(N1, DID1))).type());
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)this.sms.getRole(N1, DID1));
        Assert.assertNull((String)"wrong event", (Object)Futures.getUnchecked((Future)this.sms.setMaster(N1, DID1)));
        this.put(DID2, N1, false, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.STANDBY, (Object)this.sms.getRole(N1, DID2));
        Assert.assertEquals((String)"wrong event", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)((MastershipEvent)Futures.getUnchecked((Future)this.sms.setMaster(N1, DID2))).type());
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)this.sms.getRole(N1, DID2));
    }

    @Test
    public void getDevices() {
        HashSet d = Sets.newHashSet((Object[])new DeviceId[]{DID1, DID2});
        this.put(DID1, N2, true, true);
        this.put(DID2, N2, true, true);
        this.put(DID3, N1, true, true);
        Assert.assertTrue((String)"wrong devices", (boolean)d.equals(this.sms.getDevices(N2)));
    }

    @Test
    public void getTermFor() {
        this.put(DID1, N1, true, true);
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N1, (long)0L), (Object)this.sms.getTermFor(DID1));
        this.sms.setMaster(N2, DID1);
        this.sms.setMaster(N1, DID1);
        Assert.assertEquals((String)"wrong term", (Object)MastershipTerm.of((NodeId)N1, (long)2L), (Object)this.sms.getTermFor(DID1));
    }

    @Test
    public void requestRole() {
        this.put(DID1, N1, false, false);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)Futures.getUnchecked((Future)this.sms.requestRole(DID1)));
        this.put(DID2, N1, false, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)Futures.getUnchecked((Future)this.sms.requestRole(DID2)));
        this.put(DID3, N2, true, false);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.STANDBY, (Object)Futures.getUnchecked((Future)this.sms.requestRole(DID3)));
        this.put(DID4, N1, true, true);
        Assert.assertEquals((String)"wrong role", (Object)MastershipRole.MASTER, (Object)Futures.getUnchecked((Future)this.sms.requestRole(DID4)));
    }

    @Test
    public void unsetMaster() {
        this.put(DID1, N1, false, false);
        this.sms.setStandby(N1, DID1);
        Assert.assertTrue((String)"not backed up", (boolean)((List)this.sms.backups.get(DID1)).contains(N1));
        int prev = ((AtomicInteger)this.sms.termMap.get(DID1)).get();
        this.sms.setStandby(N1, DID1);
        Assert.assertEquals((String)"term should not change", (long)prev, (long)((AtomicInteger)this.sms.termMap.get(DID1)).get());
        this.put(DID1, N1, true, false);
        Assert.assertNull((String)"expect no MASTER event", (Object)((MastershipEvent)Futures.getUnchecked((Future)this.sms.setStandby(N1, DID1))).roleInfo().master());
        Assert.assertNull((String)"wrong node", this.sms.masterMap.get(DID1));
        this.sms.masterMap.clear();
        this.put(DID1, N1, true, true);
        this.put(DID1, N2, false, true);
        this.put(DID2, N2, true, true);
        MastershipEvent event = (MastershipEvent)Futures.getUnchecked((Future)this.sms.setStandby(N1, DID1));
        Assert.assertEquals((String)"wrong event", (Object)MastershipEvent.Type.MASTER_CHANGED, (Object)event.type());
        Assert.assertEquals((String)"wrong master", (Object)N2, (Object)event.roleInfo().master());
    }

    private void put(DeviceId dev, NodeId node, boolean master, boolean backup) {
        if (master) {
            this.sms.masterMap.put(dev, node);
        } else if (backup) {
            List stbys = this.sms.backups.getOrDefault(dev, new ArrayList());
            stbys.add(node);
            this.sms.backups.put(dev, stbys);
        }
        this.sms.termMap.put(dev, new AtomicInteger());
    }
}

